/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sesv2.model.DkimAttributes;
import software.amazon.awssdk.services.sesv2.model.IdentityType;
import software.amazon.awssdk.services.sesv2.model.MailFromAttributes;
import software.amazon.awssdk.services.sesv2.model.PolicyMapCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.services.sesv2.model.Tag;
import software.amazon.awssdk.services.sesv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEmailIdentityResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetEmailIdentityResponse> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityType").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::identityTypeAsString)).setter(GetEmailIdentityResponse.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final SdkField<Boolean> FEEDBACK_FORWARDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FeedbackForwardingStatus").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::feedbackForwardingStatus)).setter(GetEmailIdentityResponse.setter(Builder::feedbackForwardingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingStatus").build()}).build();
    private static final SdkField<Boolean> VERIFIED_FOR_SENDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VerifiedForSendingStatus").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::verifiedForSendingStatus)).setter(GetEmailIdentityResponse.setter(Builder::verifiedForSendingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedForSendingStatus").build()}).build();
    private static final SdkField<DkimAttributes> DKIM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DkimAttributes").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::dkimAttributes)).setter(GetEmailIdentityResponse.setter(Builder::dkimAttributes)).constructor(DkimAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimAttributes").build()}).build();
    private static final SdkField<MailFromAttributes> MAIL_FROM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MailFromAttributes").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::mailFromAttributes)).setter(GetEmailIdentityResponse.setter(Builder::mailFromAttributes)).constructor(MailFromAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromAttributes").build()}).build();
    private static final SdkField<Map<String, String>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Policies").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::policies)).setter(GetEmailIdentityResponse.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::tags)).setter(GetEmailIdentityResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(GetEmailIdentityResponse.getter(GetEmailIdentityResponse::configurationSetName)).setter(GetEmailIdentityResponse.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD, FEEDBACK_FORWARDING_STATUS_FIELD, VERIFIED_FOR_SENDING_STATUS_FIELD, DKIM_ATTRIBUTES_FIELD, MAIL_FROM_ATTRIBUTES_FIELD, POLICIES_FIELD, TAGS_FIELD, CONFIGURATION_SET_NAME_FIELD));
    private final String identityType;
    private final Boolean feedbackForwardingStatus;
    private final Boolean verifiedForSendingStatus;
    private final DkimAttributes dkimAttributes;
    private final MailFromAttributes mailFromAttributes;
    private final Map<String, String> policies;
    private final List<Tag> tags;
    private final String configurationSetName;

    private GetEmailIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.feedbackForwardingStatus = builder.feedbackForwardingStatus;
        this.verifiedForSendingStatus = builder.verifiedForSendingStatus;
        this.dkimAttributes = builder.dkimAttributes;
        this.mailFromAttributes = builder.mailFromAttributes;
        this.policies = builder.policies;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
    }

    public final IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public final String identityTypeAsString() {
        return this.identityType;
    }

    public final Boolean feedbackForwardingStatus() {
        return this.feedbackForwardingStatus;
    }

    public final Boolean verifiedForSendingStatus() {
        return this.verifiedForSendingStatus;
    }

    public final DkimAttributes dkimAttributes() {
        return this.dkimAttributes;
    }

    public final MailFromAttributes mailFromAttributes() {
        return this.mailFromAttributes;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> policies() {
        return this.policies;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackForwardingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedForSendingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEmailIdentityResponse)) {
            return false;
        }
        GetEmailIdentityResponse other = (GetEmailIdentityResponse)((Object)obj);
        return Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.feedbackForwardingStatus(), other.feedbackForwardingStatus()) && Objects.equals(this.verifiedForSendingStatus(), other.verifiedForSendingStatus()) && Objects.equals(this.dkimAttributes(), other.dkimAttributes()) && Objects.equals(this.mailFromAttributes(), other.mailFromAttributes()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationSetName(), other.configurationSetName());
    }

    public final String toString() {
        return ToString.builder((String)"GetEmailIdentityResponse").add("IdentityType", (Object)this.identityTypeAsString()).add("FeedbackForwardingStatus", (Object)this.feedbackForwardingStatus()).add("VerifiedForSendingStatus", (Object)this.verifiedForSendingStatus()).add("DkimAttributes", (Object)this.dkimAttributes()).add("MailFromAttributes", (Object)this.mailFromAttributes()).add("Policies", this.hasPolicies() ? this.policies() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ConfigurationSetName", (Object)this.configurationSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "FeedbackForwardingStatus": {
                return Optional.ofNullable(clazz.cast(this.feedbackForwardingStatus()));
            }
            case "VerifiedForSendingStatus": {
                return Optional.ofNullable(clazz.cast(this.verifiedForSendingStatus()));
            }
            case "DkimAttributes": {
                return Optional.ofNullable(clazz.cast(this.dkimAttributes()));
            }
            case "MailFromAttributes": {
                return Optional.ofNullable(clazz.cast(this.mailFromAttributes()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEmailIdentityResponse, T> g) {
        return obj -> g.apply((GetEmailIdentityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String identityType;
        private Boolean feedbackForwardingStatus;
        private Boolean verifiedForSendingStatus;
        private DkimAttributes dkimAttributes;
        private MailFromAttributes mailFromAttributes;
        private Map<String, String> policies = DefaultSdkAutoConstructMap.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEmailIdentityResponse model) {
            super(model);
            this.identityType(model.identityType);
            this.feedbackForwardingStatus(model.feedbackForwardingStatus);
            this.verifiedForSendingStatus(model.verifiedForSendingStatus);
            this.dkimAttributes(model.dkimAttributes);
            this.mailFromAttributes(model.mailFromAttributes);
            this.policies(model.policies);
            this.tags(model.tags);
            this.configurationSetName(model.configurationSetName);
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final Boolean getFeedbackForwardingStatus() {
            return this.feedbackForwardingStatus;
        }

        @Override
        public final Builder feedbackForwardingStatus(Boolean feedbackForwardingStatus) {
            this.feedbackForwardingStatus = feedbackForwardingStatus;
            return this;
        }

        public final void setFeedbackForwardingStatus(Boolean feedbackForwardingStatus) {
            this.feedbackForwardingStatus = feedbackForwardingStatus;
        }

        public final Boolean getVerifiedForSendingStatus() {
            return this.verifiedForSendingStatus;
        }

        @Override
        public final Builder verifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
            return this;
        }

        public final void setVerifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
        }

        public final DkimAttributes.Builder getDkimAttributes() {
            return this.dkimAttributes != null ? this.dkimAttributes.toBuilder() : null;
        }

        @Override
        public final Builder dkimAttributes(DkimAttributes dkimAttributes) {
            this.dkimAttributes = dkimAttributes;
            return this;
        }

        public final void setDkimAttributes(DkimAttributes.BuilderImpl dkimAttributes) {
            this.dkimAttributes = dkimAttributes != null ? dkimAttributes.build() : null;
        }

        public final MailFromAttributes.Builder getMailFromAttributes() {
            return this.mailFromAttributes != null ? this.mailFromAttributes.toBuilder() : null;
        }

        @Override
        public final Builder mailFromAttributes(MailFromAttributes mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes;
            return this;
        }

        public final void setMailFromAttributes(MailFromAttributes.BuilderImpl mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes != null ? mailFromAttributes.build() : null;
        }

        public final Map<String, String> getPolicies() {
            if (this.policies instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.policies;
        }

        @Override
        public final Builder policies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
            return this;
        }

        public final void setPolicies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public GetEmailIdentityResponse build() {
            return new GetEmailIdentityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEmailIdentityResponse> {
        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder feedbackForwardingStatus(Boolean var1);

        public Builder verifiedForSendingStatus(Boolean var1);

        public Builder dkimAttributes(DkimAttributes var1);

        default public Builder dkimAttributes(Consumer<DkimAttributes.Builder> dkimAttributes) {
            return this.dkimAttributes((DkimAttributes)((DkimAttributes.Builder)DkimAttributes.builder().applyMutation(dkimAttributes)).build());
        }

        public Builder mailFromAttributes(MailFromAttributes var1);

        default public Builder mailFromAttributes(Consumer<MailFromAttributes.Builder> mailFromAttributes) {
            return this.mailFromAttributes((MailFromAttributes)((MailFromAttributes.Builder)MailFromAttributes.builder().applyMutation(mailFromAttributes)).build());
        }

        public Builder policies(Map<String, String> var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder configurationSetName(String var1);
    }
}

