/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.DataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportDataSource> {
    private static final SdkField<String> S3_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Url").getter(ImportDataSource.getter(ImportDataSource::s3Url)).setter(ImportDataSource.setter(Builder::s3Url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(ImportDataSource.getter(ImportDataSource::dataFormatAsString)).setter(ImportDataSource.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URL_FIELD, DATA_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Url;
    private final String dataFormat;

    private ImportDataSource(BuilderImpl builder) {
        this.s3Url = builder.s3Url;
        this.dataFormat = builder.dataFormat;
    }

    public final String s3Url() {
        return this.s3Url;
    }

    public final DataFormat dataFormat() {
        return DataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDataSource)) {
            return false;
        }
        ImportDataSource other = (ImportDataSource)obj;
        return Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportDataSource").add("S3Url", (Object)this.s3Url()).add("DataFormat", (Object)this.dataFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportDataSource, T> g) {
        return obj -> g.apply((ImportDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Url;
        private String dataFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDataSource model) {
            this.s3Url(model.s3Url);
            this.dataFormat(model.dataFormat);
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public ImportDataSource build() {
            return new ImportDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportDataSource> {
        public Builder s3Url(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormat var1);
    }
}

