/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SubscriptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Topic
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Topic> {
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(Topic.getter(Topic::topicName)).setter(Topic.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Topic.getter(Topic::displayName)).setter(Topic.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Topic.getter(Topic::description)).setter(Topic.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEFAULT_SUBSCRIPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSubscriptionStatus").getter(Topic.getter(Topic::defaultSubscriptionStatusAsString)).setter(Topic.setter(Builder::defaultSubscriptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubscriptionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_SUBSCRIPTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topicName;
    private final String displayName;
    private final String description;
    private final String defaultSubscriptionStatus;

    private Topic(BuilderImpl builder) {
        this.topicName = builder.topicName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.defaultSubscriptionStatus = builder.defaultSubscriptionStatus;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final SubscriptionStatus defaultSubscriptionStatus() {
        return SubscriptionStatus.fromValue(this.defaultSubscriptionStatus);
    }

    public final String defaultSubscriptionStatusAsString() {
        return this.defaultSubscriptionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubscriptionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Topic)) {
            return false;
        }
        Topic other = (Topic)obj;
        return Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultSubscriptionStatusAsString(), other.defaultSubscriptionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Topic").add("TopicName", (Object)this.topicName()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("DefaultSubscriptionStatus", (Object)this.defaultSubscriptionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultSubscriptionStatus": {
                return Optional.ofNullable(clazz.cast(this.defaultSubscriptionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Topic, T> g) {
        return obj -> g.apply((Topic)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicName;
        private String displayName;
        private String description;
        private String defaultSubscriptionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Topic model) {
            this.topicName(model.topicName);
            this.displayName(model.displayName);
            this.description(model.description);
            this.defaultSubscriptionStatus(model.defaultSubscriptionStatus);
        }

        public final String getTopicName() {
            return this.topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultSubscriptionStatus() {
            return this.defaultSubscriptionStatus;
        }

        @Override
        public final Builder defaultSubscriptionStatus(String defaultSubscriptionStatus) {
            this.defaultSubscriptionStatus = defaultSubscriptionStatus;
            return this;
        }

        @Override
        public final Builder defaultSubscriptionStatus(SubscriptionStatus defaultSubscriptionStatus) {
            this.defaultSubscriptionStatus(defaultSubscriptionStatus == null ? null : defaultSubscriptionStatus.toString());
            return this;
        }

        public final void setDefaultSubscriptionStatus(String defaultSubscriptionStatus) {
            this.defaultSubscriptionStatus = defaultSubscriptionStatus;
        }

        public Topic build() {
            return new Topic(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Topic> {
        public Builder topicName(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder defaultSubscriptionStatus(String var1);

        public Builder defaultSubscriptionStatus(SubscriptionStatus var1);
    }
}

