/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ImportDestination;
import software.amazon.awssdk.services.sesv2.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportJobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(ImportJobSummary.getter(ImportJobSummary::jobId)).setter(ImportJobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<ImportDestination> IMPORT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportDestination").getter(ImportJobSummary.getter(ImportJobSummary::importDestination)).setter(ImportJobSummary.setter(Builder::importDestination)).constructor(ImportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDestination").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(ImportJobSummary.getter(ImportJobSummary::jobStatusAsString)).setter(ImportJobSummary.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ImportJobSummary.getter(ImportJobSummary::createdTimestamp)).setter(ImportJobSummary.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, IMPORT_DESTINATION_FIELD, JOB_STATUS_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final ImportDestination importDestination;
    private final String jobStatus;
    private final Instant createdTimestamp;

    private ImportJobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.importDestination = builder.importDestination;
        this.jobStatus = builder.jobStatus;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public String jobId() {
        return this.jobId;
    }

    public ImportDestination importDestination() {
        return this.importDestination;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobSummary)) {
            return false;
        }
        ImportJobSummary other = (ImportJobSummary)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.importDestination(), other.importDestination()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"ImportJobSummary").add("JobId", (Object)this.jobId()).add("ImportDestination", (Object)this.importDestination()).add("JobStatus", (Object)this.jobStatusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "ImportDestination": {
                return Optional.ofNullable(clazz.cast(this.importDestination()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportJobSummary, T> g) {
        return obj -> g.apply((ImportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private ImportDestination importDestination;
        private String jobStatus;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobSummary model) {
            this.jobId(model.jobId);
            this.importDestination(model.importDestination);
            this.jobStatus(model.jobStatus);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final ImportDestination.Builder getImportDestination() {
            return this.importDestination != null ? this.importDestination.toBuilder() : null;
        }

        @Override
        public final Builder importDestination(ImportDestination importDestination) {
            this.importDestination = importDestination;
            return this;
        }

        public final void setImportDestination(ImportDestination.BuilderImpl importDestination) {
            this.importDestination = importDestination != null ? importDestination.build() : null;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public ImportJobSummary build() {
            return new ImportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportJobSummary> {
        public Builder jobId(String var1);

        public Builder importDestination(ImportDestination var1);

        default public Builder importDestination(Consumer<ImportDestination.Builder> importDestination) {
            return this.importDestination((ImportDestination)((ImportDestination.Builder)ImportDestination.builder().applyMutation(importDestination)).build());
        }

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder createdTimestamp(Instant var1);
    }
}

