/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.TopicPreference;
import software.amazon.awssdk.services.sesv2.model.TopicPreferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, UpdateContactRequest> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactListName").getter(UpdateContactRequest.getter(UpdateContactRequest::contactListName)).setter(UpdateContactRequest.setter(Builder::contactListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactListName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(UpdateContactRequest.getter(UpdateContactRequest::emailAddress)).setter(UpdateContactRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailAddress").build()}).build();
    private static final SdkField<List<TopicPreference>> TOPIC_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicPreferences").getter(UpdateContactRequest.getter(UpdateContactRequest::topicPreferences)).setter(UpdateContactRequest.setter(Builder::topicPreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> UNSUBSCRIBE_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UnsubscribeAll").getter(UpdateContactRequest.getter(UpdateContactRequest::unsubscribeAll)).setter(UpdateContactRequest.setter(Builder::unsubscribeAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsubscribeAll").build()}).build();
    private static final SdkField<String> ATTRIBUTES_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributesData").getter(UpdateContactRequest.getter(UpdateContactRequest::attributesData)).setter(UpdateContactRequest.setter(Builder::attributesData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD, EMAIL_ADDRESS_FIELD, TOPIC_PREFERENCES_FIELD, UNSUBSCRIBE_ALL_FIELD, ATTRIBUTES_DATA_FIELD));
    private final String contactListName;
    private final String emailAddress;
    private final List<TopicPreference> topicPreferences;
    private final Boolean unsubscribeAll;
    private final String attributesData;

    private UpdateContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactListName = builder.contactListName;
        this.emailAddress = builder.emailAddress;
        this.topicPreferences = builder.topicPreferences;
        this.unsubscribeAll = builder.unsubscribeAll;
        this.attributesData = builder.attributesData;
    }

    public String contactListName() {
        return this.contactListName;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public boolean hasTopicPreferences() {
        return this.topicPreferences != null && !(this.topicPreferences instanceof SdkAutoConstructList);
    }

    public List<TopicPreference> topicPreferences() {
        return this.topicPreferences;
    }

    public Boolean unsubscribeAll() {
        return this.unsubscribeAll;
    }

    public String attributesData() {
        return this.attributesData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicPreferences() ? this.topicPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unsubscribeAll());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest)((Object)obj);
        return Objects.equals(this.contactListName(), other.contactListName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && this.hasTopicPreferences() == other.hasTopicPreferences() && Objects.equals(this.topicPreferences(), other.topicPreferences()) && Objects.equals(this.unsubscribeAll(), other.unsubscribeAll()) && Objects.equals(this.attributesData(), other.attributesData());
    }

    public String toString() {
        return ToString.builder((String)"UpdateContactRequest").add("ContactListName", (Object)this.contactListName()).add("EmailAddress", (Object)this.emailAddress()).add("TopicPreferences", this.hasTopicPreferences() ? this.topicPreferences() : null).add("UnsubscribeAll", (Object)this.unsubscribeAll()).add("AttributesData", (Object)this.attributesData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactListName": {
                return Optional.ofNullable(clazz.cast(this.contactListName()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "TopicPreferences": {
                return Optional.ofNullable(clazz.cast(this.topicPreferences()));
            }
            case "UnsubscribeAll": {
                return Optional.ofNullable(clazz.cast(this.unsubscribeAll()));
            }
            case "AttributesData": {
                return Optional.ofNullable(clazz.cast(this.attributesData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRequest, T> g) {
        return obj -> g.apply((UpdateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String contactListName;
        private String emailAddress;
        private List<TopicPreference> topicPreferences = DefaultSdkAutoConstructList.getInstance();
        private Boolean unsubscribeAll;
        private String attributesData;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRequest model) {
            super(model);
            this.contactListName(model.contactListName);
            this.emailAddress(model.emailAddress);
            this.topicPreferences(model.topicPreferences);
            this.unsubscribeAll(model.unsubscribeAll);
            this.attributesData(model.attributesData);
        }

        public final String getContactListName() {
            return this.contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final Collection<TopicPreference.Builder> getTopicPreferences() {
            if (this.topicPreferences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topicPreferences != null ? (Collection)this.topicPreferences.stream().map(TopicPreference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topicPreferences(Collection<TopicPreference> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copy(topicPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicPreferences(TopicPreference ... topicPreferences) {
            this.topicPreferences(Arrays.asList(topicPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicPreferences(Consumer<TopicPreference.Builder> ... topicPreferences) {
            this.topicPreferences(Stream.of(topicPreferences).map(c -> (TopicPreference)((TopicPreference.Builder)TopicPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopicPreferences(Collection<TopicPreference.BuilderImpl> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copyFromBuilder(topicPreferences);
        }

        public final Boolean getUnsubscribeAll() {
            return this.unsubscribeAll;
        }

        @Override
        public final Builder unsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
            return this;
        }

        public final void setUnsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
        }

        public final String getAttributesData() {
            return this.attributesData;
        }

        @Override
        public final Builder attributesData(String attributesData) {
            this.attributesData = attributesData;
            return this;
        }

        public final void setAttributesData(String attributesData) {
            this.attributesData = attributesData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactRequest> {
        public Builder contactListName(String var1);

        public Builder emailAddress(String var1);

        public Builder topicPreferences(Collection<TopicPreference> var1);

        public Builder topicPreferences(TopicPreference ... var1);

        public Builder topicPreferences(Consumer<TopicPreference.Builder> ... var1);

        public Builder unsubscribeAll(Boolean var1);

        public Builder attributesData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

