/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;

public class ListEmailIdentitiesPublisher
implements SdkPublisher<ListEmailIdentitiesResponse> {
    private final SesV2AsyncClient client;
    private final ListEmailIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEmailIdentitiesPublisher(SesV2AsyncClient client, ListEmailIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEmailIdentitiesPublisher(SesV2AsyncClient client, ListEmailIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEmailIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEmailIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEmailIdentitiesResponseFetcher
    implements AsyncPageFetcher<ListEmailIdentitiesResponse> {
        private ListEmailIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEmailIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEmailIdentitiesResponse> nextPage(ListEmailIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEmailIdentitiesPublisher.this.client.listEmailIdentities(ListEmailIdentitiesPublisher.this.firstRequest);
            }
            return ListEmailIdentitiesPublisher.this.client.listEmailIdentities((ListEmailIdentitiesRequest)((Object)ListEmailIdentitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

