/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestRenderEmailTemplateRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, TestRenderEmailTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestRenderEmailTemplateRequest.getter(TestRenderEmailTemplateRequest::templateName)).setter(TestRenderEmailTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestRenderEmailTemplateRequest.getter(TestRenderEmailTemplateRequest::templateData)).setter(TestRenderEmailTemplateRequest.setter(Builder::templateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_DATA_FIELD));
    private final String templateName;
    private final String templateData;

    private TestRenderEmailTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateData = builder.templateData;
    }

    public String templateName() {
        return this.templateName;
    }

    public String templateData() {
        return this.templateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRenderEmailTemplateRequest)) {
            return false;
        }
        TestRenderEmailTemplateRequest other = (TestRenderEmailTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateData(), other.templateData());
    }

    public String toString() {
        return ToString.builder((String)"TestRenderEmailTemplateRequest").add("TemplateName", (Object)this.templateName()).add("TemplateData", (Object)this.templateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateData": {
                return Optional.ofNullable(clazz.cast(this.templateData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestRenderEmailTemplateRequest, T> g) {
        return obj -> g.apply((TestRenderEmailTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String templateName;
        private String templateData;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRenderEmailTemplateRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.templateData(model.templateData);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getTemplateData() {
            return this.templateData;
        }

        @Override
        public final Builder templateData(String templateData) {
            this.templateData = templateData;
            return this;
        }

        public final void setTemplateData(String templateData) {
            this.templateData = templateData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestRenderEmailTemplateRequest build() {
            return new TestRenderEmailTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestRenderEmailTemplateRequest> {
        public Builder templateName(String var1);

        public Builder templateData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

