/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSuppressedDestinationRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, PutSuppressedDestinationRequest> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSuppressedDestinationRequest.getter(PutSuppressedDestinationRequest::emailAddress)).setter(PutSuppressedDestinationRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSuppressedDestinationRequest.getter(PutSuppressedDestinationRequest::reasonAsString)).setter(PutSuppressedDestinationRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD, REASON_FIELD));
    private final String emailAddress;
    private final String reason;

    private PutSuppressedDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddress = builder.emailAddress;
        this.reason = builder.reason;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public SuppressionListReason reason() {
        return SuppressionListReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSuppressedDestinationRequest)) {
            return false;
        }
        PutSuppressedDestinationRequest other = (PutSuppressedDestinationRequest)((Object)obj);
        return Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.reasonAsString(), other.reasonAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutSuppressedDestinationRequest").add("EmailAddress", (Object)this.emailAddress()).add("Reason", (Object)this.reasonAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSuppressedDestinationRequest, T> g) {
        return obj -> g.apply((PutSuppressedDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String emailAddress;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSuppressedDestinationRequest model) {
            super(model);
            this.emailAddress(model.emailAddress);
            this.reason(model.reason);
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SuppressionListReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSuppressedDestinationRequest build() {
            return new PutSuppressedDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSuppressedDestinationRequest> {
        public Builder emailAddress(String var1);

        public Builder reason(String var1);

        public Builder reason(SuppressionListReason var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

