/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.services.sesv2.model.SuppressedDestinationSummariesCopier;
import software.amazon.awssdk.services.sesv2.model.SuppressedDestinationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSuppressedDestinationsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListSuppressedDestinationsResponse> {
    private static final SdkField<List<SuppressedDestinationSummary>> SUPPRESSED_DESTINATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSuppressedDestinationsResponse.getter(ListSuppressedDestinationsResponse::suppressedDestinationSummaries)).setter(ListSuppressedDestinationsResponse.setter(Builder::suppressedDestinationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedDestinationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuppressedDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSuppressedDestinationsResponse.getter(ListSuppressedDestinationsResponse::nextToken)).setter(ListSuppressedDestinationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSED_DESTINATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SuppressedDestinationSummary> suppressedDestinationSummaries;
    private final String nextToken;

    private ListSuppressedDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.suppressedDestinationSummaries = builder.suppressedDestinationSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<SuppressedDestinationSummary> suppressedDestinationSummaries() {
        return this.suppressedDestinationSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressedDestinationSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuppressedDestinationsResponse)) {
            return false;
        }
        ListSuppressedDestinationsResponse other = (ListSuppressedDestinationsResponse)((Object)obj);
        return Objects.equals(this.suppressedDestinationSummaries(), other.suppressedDestinationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSuppressedDestinationsResponse").add("SuppressedDestinationSummaries", this.suppressedDestinationSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuppressedDestinationSummaries": {
                return Optional.ofNullable(clazz.cast(this.suppressedDestinationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSuppressedDestinationsResponse, T> g) {
        return obj -> g.apply((ListSuppressedDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<SuppressedDestinationSummary> suppressedDestinationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuppressedDestinationsResponse model) {
            super(model);
            this.suppressedDestinationSummaries(model.suppressedDestinationSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<SuppressedDestinationSummary.Builder> getSuppressedDestinationSummaries() {
            return this.suppressedDestinationSummaries != null ? (Collection)this.suppressedDestinationSummaries.stream().map(SuppressedDestinationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suppressedDestinationSummaries(Collection<SuppressedDestinationSummary> suppressedDestinationSummaries) {
            this.suppressedDestinationSummaries = SuppressedDestinationSummariesCopier.copy(suppressedDestinationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedDestinationSummaries(SuppressedDestinationSummary ... suppressedDestinationSummaries) {
            this.suppressedDestinationSummaries(Arrays.asList(suppressedDestinationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedDestinationSummaries(Consumer<SuppressedDestinationSummary.Builder> ... suppressedDestinationSummaries) {
            this.suppressedDestinationSummaries(Stream.of(suppressedDestinationSummaries).map(c -> (SuppressedDestinationSummary)((SuppressedDestinationSummary.Builder)SuppressedDestinationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuppressedDestinationSummaries(Collection<SuppressedDestinationSummary.BuilderImpl> suppressedDestinationSummaries) {
            this.suppressedDestinationSummaries = SuppressedDestinationSummariesCopier.copyFromBuilder(suppressedDestinationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSuppressedDestinationsResponse build() {
            return new ListSuppressedDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSuppressedDestinationsResponse> {
        public Builder suppressedDestinationSummaries(Collection<SuppressedDestinationSummary> var1);

        public Builder suppressedDestinationSummaries(SuppressedDestinationSummary ... var1);

        public Builder suppressedDestinationSummaries(Consumer<SuppressedDestinationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

