/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityCampaign;
import software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityCampaignListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainDeliverabilityCampaignsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListDomainDeliverabilityCampaignsResponse> {
    private static final SdkField<List<DomainDeliverabilityCampaign>> DOMAIN_DELIVERABILITY_CAMPAIGNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDomainDeliverabilityCampaignsResponse.getter(ListDomainDeliverabilityCampaignsResponse::domainDeliverabilityCampaigns)).setter(ListDomainDeliverabilityCampaignsResponse.setter(Builder::domainDeliverabilityCampaigns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDeliverabilityCampaigns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainDeliverabilityCampaign::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDomainDeliverabilityCampaignsResponse.getter(ListDomainDeliverabilityCampaignsResponse::nextToken)).setter(ListDomainDeliverabilityCampaignsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_DELIVERABILITY_CAMPAIGNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns;
    private final String nextToken;

    private ListDomainDeliverabilityCampaignsResponse(BuilderImpl builder) {
        super(builder);
        this.domainDeliverabilityCampaigns = builder.domainDeliverabilityCampaigns;
        this.nextToken = builder.nextToken;
    }

    public List<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns() {
        return this.domainDeliverabilityCampaigns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainDeliverabilityCampaigns());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainDeliverabilityCampaignsResponse)) {
            return false;
        }
        ListDomainDeliverabilityCampaignsResponse other = (ListDomainDeliverabilityCampaignsResponse)((Object)obj);
        return Objects.equals(this.domainDeliverabilityCampaigns(), other.domainDeliverabilityCampaigns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDomainDeliverabilityCampaignsResponse").add("DomainDeliverabilityCampaigns", this.domainDeliverabilityCampaigns()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainDeliverabilityCampaigns": {
                return Optional.ofNullable(clazz.cast(this.domainDeliverabilityCampaigns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainDeliverabilityCampaignsResponse, T> g) {
        return obj -> g.apply((ListDomainDeliverabilityCampaignsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainDeliverabilityCampaignsResponse model) {
            super(model);
            this.domainDeliverabilityCampaigns(model.domainDeliverabilityCampaigns);
            this.nextToken(model.nextToken);
        }

        public final Collection<DomainDeliverabilityCampaign.Builder> getDomainDeliverabilityCampaigns() {
            return this.domainDeliverabilityCampaigns != null ? (Collection)this.domainDeliverabilityCampaigns.stream().map(DomainDeliverabilityCampaign::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainDeliverabilityCampaigns(Collection<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns) {
            this.domainDeliverabilityCampaigns = DomainDeliverabilityCampaignListCopier.copy(domainDeliverabilityCampaigns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainDeliverabilityCampaigns(DomainDeliverabilityCampaign ... domainDeliverabilityCampaigns) {
            this.domainDeliverabilityCampaigns(Arrays.asList(domainDeliverabilityCampaigns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainDeliverabilityCampaigns(Consumer<DomainDeliverabilityCampaign.Builder> ... domainDeliverabilityCampaigns) {
            this.domainDeliverabilityCampaigns(Stream.of(domainDeliverabilityCampaigns).map(c -> (DomainDeliverabilityCampaign)((DomainDeliverabilityCampaign.Builder)DomainDeliverabilityCampaign.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainDeliverabilityCampaigns(Collection<DomainDeliverabilityCampaign.BuilderImpl> domainDeliverabilityCampaigns) {
            this.domainDeliverabilityCampaigns = DomainDeliverabilityCampaignListCopier.copyFromBuilder(domainDeliverabilityCampaigns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDomainDeliverabilityCampaignsResponse build() {
            return new ListDomainDeliverabilityCampaignsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainDeliverabilityCampaignsResponse> {
        public Builder domainDeliverabilityCampaigns(Collection<DomainDeliverabilityCampaign> var1);

        public Builder domainDeliverabilityCampaigns(DomainDeliverabilityCampaign ... var1);

        public Builder domainDeliverabilityCampaigns(Consumer<DomainDeliverabilityCampaign.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

