/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.BlacklistItemNamesCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlacklistReportsRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, GetBlacklistReportsRequest> {
    private static final SdkField<List<String>> BLACKLIST_ITEM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetBlacklistReportsRequest.getter(GetBlacklistReportsRequest::blacklistItemNames)).setter(GetBlacklistReportsRequest.setter(Builder::blacklistItemNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("BlacklistItemNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKLIST_ITEM_NAMES_FIELD));
    private final List<String> blacklistItemNames;

    private GetBlacklistReportsRequest(BuilderImpl builder) {
        super(builder);
        this.blacklistItemNames = builder.blacklistItemNames;
    }

    public List<String> blacklistItemNames() {
        return this.blacklistItemNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blacklistItemNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlacklistReportsRequest)) {
            return false;
        }
        GetBlacklistReportsRequest other = (GetBlacklistReportsRequest)((Object)obj);
        return Objects.equals(this.blacklistItemNames(), other.blacklistItemNames());
    }

    public String toString() {
        return ToString.builder((String)"GetBlacklistReportsRequest").add("BlacklistItemNames", this.blacklistItemNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlacklistItemNames": {
                return Optional.ofNullable(clazz.cast(this.blacklistItemNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlacklistReportsRequest, T> g) {
        return obj -> g.apply((GetBlacklistReportsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private List<String> blacklistItemNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlacklistReportsRequest model) {
            super(model);
            this.blacklistItemNames(model.blacklistItemNames);
        }

        public final Collection<String> getBlacklistItemNames() {
            return this.blacklistItemNames;
        }

        @Override
        public final Builder blacklistItemNames(Collection<String> blacklistItemNames) {
            this.blacklistItemNames = BlacklistItemNamesCopier.copy(blacklistItemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blacklistItemNames(String ... blacklistItemNames) {
            this.blacklistItemNames(Arrays.asList(blacklistItemNames));
            return this;
        }

        public final void setBlacklistItemNames(Collection<String> blacklistItemNames) {
            this.blacklistItemNames = BlacklistItemNamesCopier.copy(blacklistItemNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlacklistReportsRequest build() {
            return new GetBlacklistReportsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlacklistReportsRequest> {
        public Builder blacklistItemNames(Collection<String> var1);

        public Builder blacklistItemNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

