/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.services.ses.model.TemplateMetadata;
import software.amazon.awssdk.services.ses.model.TemplateMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTemplatesResponse
extends SesResponse
implements ToCopyableBuilder<Builder, ListTemplatesResponse> {
    private static final SdkField<List<TemplateMetadata>> TEMPLATES_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTemplatesResponse.getter(ListTemplatesResponse::templatesMetadata)).setter(ListTemplatesResponse.setter(Builder::templatesMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatesMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTemplatesResponse.getter(ListTemplatesResponse::nextToken)).setter(ListTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_METADATA_FIELD, NEXT_TOKEN_FIELD));
    private final List<TemplateMetadata> templatesMetadata;
    private final String nextToken;

    private ListTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templatesMetadata = builder.templatesMetadata;
        this.nextToken = builder.nextToken;
    }

    public List<TemplateMetadata> templatesMetadata() {
        return this.templatesMetadata;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templatesMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesResponse)) {
            return false;
        }
        ListTemplatesResponse other = (ListTemplatesResponse)((Object)obj);
        return Objects.equals(this.templatesMetadata(), other.templatesMetadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTemplatesResponse").add("TemplatesMetadata", this.templatesMetadata()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplatesMetadata": {
                return Optional.ofNullable(clazz.cast(this.templatesMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplatesResponse, T> g) {
        return obj -> g.apply((ListTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private List<TemplateMetadata> templatesMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesResponse model) {
            super(model);
            this.templatesMetadata(model.templatesMetadata);
            this.nextToken(model.nextToken);
        }

        public final Collection<TemplateMetadata.Builder> getTemplatesMetadata() {
            return this.templatesMetadata != null ? (Collection)this.templatesMetadata.stream().map(TemplateMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder templatesMetadata(Collection<TemplateMetadata> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copy(templatesMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesMetadata(TemplateMetadata ... templatesMetadata) {
            this.templatesMetadata(Arrays.asList(templatesMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesMetadata(Consumer<TemplateMetadata.Builder> ... templatesMetadata) {
            this.templatesMetadata(Stream.of(templatesMetadata).map(c -> (TemplateMetadata)((TemplateMetadata.Builder)TemplateMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTemplatesMetadata(Collection<TemplateMetadata.BuilderImpl> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copyFromBuilder(templatesMetadata);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTemplatesResponse build() {
            return new ListTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTemplatesResponse> {
        public Builder templatesMetadata(Collection<TemplateMetadata> var1);

        public Builder templatesMetadata(TemplateMetadata ... var1);

        public Builder templatesMetadata(Consumer<TemplateMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

