/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.ReceiptIpFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReceiptFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReceiptFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReceiptFilter.getter(ReceiptFilter::name)).setter(ReceiptFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ReceiptIpFilter> IP_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReceiptFilter.getter(ReceiptFilter::ipFilter)).setter(ReceiptFilter.setter(Builder::ipFilter)).constructor(ReceiptIpFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IP_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ReceiptIpFilter ipFilter;

    private ReceiptFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.ipFilter = builder.ipFilter;
    }

    public String name() {
        return this.name;
    }

    public ReceiptIpFilter ipFilter() {
        return this.ipFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptFilter)) {
            return false;
        }
        ReceiptFilter other = (ReceiptFilter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ipFilter(), other.ipFilter());
    }

    public String toString() {
        return ToString.builder((String)"ReceiptFilter").add("Name", (Object)this.name()).add("IpFilter", (Object)this.ipFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IpFilter": {
                return Optional.ofNullable(clazz.cast(this.ipFilter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReceiptFilter, T> g) {
        return obj -> g.apply((ReceiptFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ReceiptIpFilter ipFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptFilter model) {
            this.name(model.name);
            this.ipFilter(model.ipFilter);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ReceiptIpFilter.Builder getIpFilter() {
            return this.ipFilter != null ? this.ipFilter.toBuilder() : null;
        }

        @Override
        public final Builder ipFilter(ReceiptIpFilter ipFilter) {
            this.ipFilter = ipFilter;
            return this;
        }

        public final void setIpFilter(ReceiptIpFilter.BuilderImpl ipFilter) {
            this.ipFilter = ipFilter != null ? ipFilter.build() : null;
        }

        public ReceiptFilter build() {
            return new ReceiptFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReceiptFilter> {
        public Builder name(String var1);

        public Builder ipFilter(ReceiptIpFilter var1);

        default public Builder ipFilter(Consumer<ReceiptIpFilter.Builder> ipFilter) {
            return this.ipFilter((ReceiptIpFilter)((ReceiptIpFilter.Builder)ReceiptIpFilter.builder().applyMutation(ipFilter)).build());
        }
    }
}

