/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata;
import software.amazon.awssdk.services.ses.model.ReceiptRulesListCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReceiptRuleSetResponse
extends SesResponse
implements ToCopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
    private static final SdkField<ReceiptRuleSetMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeReceiptRuleSetResponse.getter(DescribeReceiptRuleSetResponse::metadata)).setter(DescribeReceiptRuleSetResponse.setter(Builder::metadata)).constructor(ReceiptRuleSetMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<List<ReceiptRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReceiptRuleSetResponse.getter(DescribeReceiptRuleSetResponse::rules)).setter(DescribeReceiptRuleSetResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReceiptRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, RULES_FIELD));
    private final ReceiptRuleSetMetadata metadata;
    private final List<ReceiptRule> rules;

    private DescribeReceiptRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.rules = builder.rules;
    }

    public ReceiptRuleSetMetadata metadata() {
        return this.metadata;
    }

    public List<ReceiptRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleSetResponse)) {
            return false;
        }
        DescribeReceiptRuleSetResponse other = (DescribeReceiptRuleSetResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReceiptRuleSetResponse").add("Metadata", (Object)this.metadata()).add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReceiptRuleSetResponse, T> g) {
        return obj -> g.apply((DescribeReceiptRuleSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private ReceiptRuleSetMetadata metadata;
        private List<ReceiptRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleSetResponse model) {
            super(model);
            this.metadata(model.metadata);
            this.rules(model.rules);
        }

        public final ReceiptRuleSetMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ReceiptRuleSetMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Collection<ReceiptRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(ReceiptRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReceiptRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ReceiptRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (ReceiptRule)((ReceiptRule.Builder)ReceiptRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<ReceiptRule.BuilderImpl> rules) {
            this.rules = ReceiptRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public DescribeReceiptRuleSetResponse build() {
            return new DescribeReceiptRuleSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
        public Builder metadata(ReceiptRuleSetMetadata var1);

        default public Builder metadata(Consumer<ReceiptRuleSetMetadata.Builder> metadata) {
            return this.metadata((ReceiptRuleSetMetadata)((ReceiptRuleSetMetadata.Builder)ReceiptRuleSetMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder rules(Collection<ReceiptRule> var1);

        public Builder rules(ReceiptRule ... var1);

        public Builder rules(Consumer<ReceiptRule.Builder> ... var1);
    }
}

