/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisFirehoseDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisFirehoseDestination> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IAMRoleARN").getter(KinesisFirehoseDestination.getter(KinesisFirehoseDestination::iamRoleARN)).setter(KinesisFirehoseDestination.setter(Builder::iamRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleARN").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStreamARN").getter(KinesisFirehoseDestination.getter(KinesisFirehoseDestination::deliveryStreamARN)).setter(KinesisFirehoseDestination.setter(Builder::deliveryStreamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD, DELIVERY_STREAM_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisFirehoseDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String iamRoleARN;
    private final String deliveryStreamARN;

    private KinesisFirehoseDestination(BuilderImpl builder) {
        this.iamRoleARN = builder.iamRoleARN;
        this.deliveryStreamARN = builder.deliveryStreamARN;
    }

    public final String iamRoleARN() {
        return this.iamRoleARN;
    }

    public final String deliveryStreamARN() {
        return this.deliveryStreamARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestination)) {
            return false;
        }
        KinesisFirehoseDestination other = (KinesisFirehoseDestination)obj;
        return Objects.equals(this.iamRoleARN(), other.iamRoleARN()) && Objects.equals(this.deliveryStreamARN(), other.deliveryStreamARN());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisFirehoseDestination").add("IAMRoleARN", (Object)this.iamRoleARN()).add("DeliveryStreamARN", (Object)this.deliveryStreamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IAMRoleARN": {
                return Optional.ofNullable(clazz.cast(this.iamRoleARN()));
            }
            case "DeliveryStreamARN": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IAMRoleARN", IAM_ROLE_ARN_FIELD);
        map.put("DeliveryStreamARN", DELIVERY_STREAM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseDestination, T> g) {
        return obj -> g.apply((KinesisFirehoseDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String iamRoleARN;
        private String deliveryStreamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestination model) {
            this.iamRoleARN(model.iamRoleARN);
            this.deliveryStreamARN(model.deliveryStreamARN);
        }

        public final String getIamRoleARN() {
            return this.iamRoleARN;
        }

        public final void setIamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
        }

        @Override
        public final Builder iamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
            return this;
        }

        public final String getDeliveryStreamARN() {
            return this.deliveryStreamARN;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public KinesisFirehoseDestination build() {
            return new KinesisFirehoseDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisFirehoseDestination> {
        public Builder iamRoleARN(String var1);

        public Builder deliveryStreamARN(String var1);
    }
}

