/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplateRequest extends SesRequest implements
        ToCopyableBuilder<UpdateTemplateRequest.Builder, UpdateTemplateRequest> {
    private static final SdkField<Template> TEMPLATE_FIELD = SdkField.<Template> builder(MarshallingType.SDK_POJO)
            .memberName("Template").getter(getter(UpdateTemplateRequest::template)).setter(setter(Builder::template))
            .constructor(Template::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Template").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Template template;

    private UpdateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.template = builder.template;
    }

    /**
     * Returns the value of the Template property for this object.
     * 
     * @return The value of the Template property for this object.
     */
    public final Template template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateRequest)) {
            return false;
        }
        UpdateTemplateRequest other = (UpdateTemplateRequest) obj;
        return Objects.equals(template(), other.template());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTemplateRequest").add("Template", template()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Template":
            return Optional.ofNullable(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Template", TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTemplateRequest> {
        /**
         * Sets the value of the Template property for this object.
         *
         * @param template
         *        The new value for the Template property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Template template);

        /**
         * Sets the value of the Template property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Template.Builder} avoiding the need to
         * create one manually via {@link Template#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #template(Template)}.
         * 
         * @param template
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #template(Template)
         */
        default Builder template(Consumer<Template.Builder> template) {
            return template(Template.builder().applyMutation(template).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private Template template;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateRequest model) {
            super(model);
            template(model.template);
        }

        public final Template.Builder getTemplate() {
            return template != null ? template.toBuilder() : null;
        }

        public final void setTemplate(Template.BuilderImpl template) {
            this.template = template != null ? template.build() : null;
        }

        @Override
        public final Builder template(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateRequest build() {
            return new UpdateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
