/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendRawEmailRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SendRawEmailRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(SendRawEmailRequest.getter(SendRawEmailRequest::source)).setter(SendRawEmailRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(SendRawEmailRequest.getter(SendRawEmailRequest::destinations)).setter(SendRawEmailRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RawMessage> RAW_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RawMessage").getter(SendRawEmailRequest.getter(SendRawEmailRequest::rawMessage)).setter(SendRawEmailRequest.setter(Builder::rawMessage)).constructor(RawMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawMessage").build()}).build();
    private static final SdkField<String> FROM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromArn").getter(SendRawEmailRequest.getter(SendRawEmailRequest::fromArn)).setter(SendRawEmailRequest.setter(Builder::fromArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromArn").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(SendRawEmailRequest.getter(SendRawEmailRequest::sourceArn)).setter(SendRawEmailRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> RETURN_PATH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnPathArn").getter(SendRawEmailRequest.getter(SendRawEmailRequest::returnPathArn)).setter(SendRawEmailRequest.setter(Builder::returnPathArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPathArn").build()}).build();
    private static final SdkField<List<MessageTag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SendRawEmailRequest.getter(SendRawEmailRequest::tags)).setter(SendRawEmailRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendRawEmailRequest.getter(SendRawEmailRequest::configurationSetName)).setter(SendRawEmailRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATIONS_FIELD, RAW_MESSAGE_FIELD, FROM_ARN_FIELD, SOURCE_ARN_FIELD, RETURN_PATH_ARN_FIELD, TAGS_FIELD, CONFIGURATION_SET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendRawEmailRequest.memberNameToFieldInitializer();
    private final String source;
    private final List<String> destinations;
    private final RawMessage rawMessage;
    private final String fromArn;
    private final String sourceArn;
    private final String returnPathArn;
    private final List<MessageTag> tags;
    private final String configurationSetName;

    private SendRawEmailRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.destinations = builder.destinations;
        this.rawMessage = builder.rawMessage;
        this.fromArn = builder.fromArn;
        this.sourceArn = builder.sourceArn;
        this.returnPathArn = builder.returnPathArn;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<String> destinations() {
        return this.destinations;
    }

    public final RawMessage rawMessage() {
        return this.rawMessage;
    }

    public final String fromArn() {
        return this.fromArn;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String returnPathArn() {
        return this.returnPathArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<MessageTag> tags() {
        return this.tags;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rawMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPathArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendRawEmailRequest)) {
            return false;
        }
        SendRawEmailRequest other = (SendRawEmailRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.rawMessage(), other.rawMessage()) && Objects.equals(this.fromArn(), other.fromArn()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.returnPathArn(), other.returnPathArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationSetName(), other.configurationSetName());
    }

    public final String toString() {
        return ToString.builder((String)"SendRawEmailRequest").add("Source", (Object)this.source()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("RawMessage", (Object)this.rawMessage()).add("FromArn", (Object)this.fromArn()).add("SourceArn", (Object)this.sourceArn()).add("ReturnPathArn", (Object)this.returnPathArn()).add("Tags", this.hasTags() ? this.tags() : null).add("ConfigurationSetName", (Object)this.configurationSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "RawMessage": {
                return Optional.ofNullable(clazz.cast(this.rawMessage()));
            }
            case "FromArn": {
                return Optional.ofNullable(clazz.cast(this.fromArn()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "ReturnPathArn": {
                return Optional.ofNullable(clazz.cast(this.returnPathArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Source", SOURCE_FIELD);
        map.put("Destinations", DESTINATIONS_FIELD);
        map.put("RawMessage", RAW_MESSAGE_FIELD);
        map.put("FromArn", FROM_ARN_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("ReturnPathArn", RETURN_PATH_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendRawEmailRequest, T> g) {
        return obj -> g.apply((SendRawEmailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String source;
        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();
        private RawMessage rawMessage;
        private String fromArn;
        private String sourceArn;
        private String returnPathArn;
        private List<MessageTag> tags = DefaultSdkAutoConstructList.getInstance();
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendRawEmailRequest model) {
            super(model);
            this.source(model.source);
            this.destinations(model.destinations);
            this.rawMessage(model.rawMessage);
            this.fromArn(model.fromArn);
            this.sourceArn(model.sourceArn);
            this.returnPathArn(model.returnPathArn);
            this.tags(model.tags);
            this.configurationSetName(model.configurationSetName);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getDestinations() {
            if (this.destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final RawMessage.Builder getRawMessage() {
            return this.rawMessage != null ? this.rawMessage.toBuilder() : null;
        }

        public final void setRawMessage(RawMessage.BuilderImpl rawMessage) {
            this.rawMessage = rawMessage != null ? rawMessage.build() : null;
        }

        @Override
        public final Builder rawMessage(RawMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public final String getFromArn() {
            return this.fromArn;
        }

        public final void setFromArn(String fromArn) {
            this.fromArn = fromArn;
        }

        @Override
        public final Builder fromArn(String fromArn) {
            this.fromArn = fromArn;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final List<MessageTag.Builder> getTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<MessageTag.BuilderImpl> tags) {
            this.tags = MessageTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(MessageTag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<MessageTag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendRawEmailRequest build() {
            return new SendRawEmailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendRawEmailRequest> {
        public Builder source(String var1);

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder rawMessage(RawMessage var1);

        default public Builder rawMessage(Consumer<RawMessage.Builder> rawMessage) {
            return this.rawMessage((RawMessage)((RawMessage.Builder)RawMessage.builder().applyMutation(rawMessage)).build());
        }

        public Builder fromArn(String var1);

        public Builder sourceArn(String var1);

        public Builder returnPathArn(String var1);

        public Builder tags(Collection<MessageTag> var1);

        public Builder tags(MessageTag ... var1);

        public Builder tags(Consumer<MessageTag.Builder> ... var1);

        public Builder configurationSetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

