/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more information about
 * setting up Easy DKIM, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetIdentityDkimEnabledRequest extends SesRequest implements
        ToCopyableBuilder<SetIdentityDkimEnabledRequest.Builder, SetIdentityDkimEnabledRequest> {
    private static final SdkField<String> IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identity").getter(getter(SetIdentityDkimEnabledRequest::identity)).setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()).build();

    private static final SdkField<Boolean> DKIM_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DkimEnabled").getter(getter(SetIdentityDkimEnabledRequest::dkimEnabled))
            .setter(setter(Builder::dkimEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_FIELD,
            DKIM_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Identity", IDENTITY_FIELD);
                    put("DkimEnabled", DKIM_ENABLED_FIELD);
                }
            });

    private final String identity;

    private final Boolean dkimEnabled;

    private SetIdentityDkimEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.dkimEnabled = builder.dkimEnabled;
    }

    /**
     * <p>
     * The identity for which DKIM signing should be enabled or disabled.
     * </p>
     * 
     * @return The identity for which DKIM signing should be enabled or disabled.
     */
    public final String identity() {
        return identity;
    }

    /**
     * <p>
     * Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for this
     * identity; <code>false</code> to disable it.
     * </p>
     * 
     * @return Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for
     *         this identity; <code>false</code> to disable it.
     */
    public final Boolean dkimEnabled() {
        return dkimEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(dkimEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityDkimEnabledRequest)) {
            return false;
        }
        SetIdentityDkimEnabledRequest other = (SetIdentityDkimEnabledRequest) obj;
        return Objects.equals(identity(), other.identity()) && Objects.equals(dkimEnabled(), other.dkimEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetIdentityDkimEnabledRequest").add("Identity", identity()).add("DkimEnabled", dkimEnabled())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "DkimEnabled":
            return Optional.ofNullable(clazz.cast(dkimEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SetIdentityDkimEnabledRequest, T> g) {
        return obj -> g.apply((SetIdentityDkimEnabledRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetIdentityDkimEnabledRequest> {
        /**
         * <p>
         * The identity for which DKIM signing should be enabled or disabled.
         * </p>
         * 
         * @param identity
         *        The identity for which DKIM signing should be enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for
         * this identity; <code>false</code> to disable it.
         * </p>
         * 
         * @param dkimEnabled
         *        Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing
         *        for this identity; <code>false</code> to disable it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimEnabled(Boolean dkimEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String identity;

        private Boolean dkimEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityDkimEnabledRequest model) {
            super(model);
            identity(model.identity);
            dkimEnabled(model.dkimEnabled);
        }

        public final String getIdentity() {
            return identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final Boolean getDkimEnabled() {
            return dkimEnabled;
        }

        public final void setDkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
        }

        @Override
        public final Builder dkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityDkimEnabledRequest build() {
            return new SetIdentityDkimEnabledRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
