/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or
 * range of IP addresses.
 * </p>
 * <p>
 * For information about setting up IP address filters, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html">Amazon SES
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReceiptFilter implements SdkPojo, Serializable, ToCopyableBuilder<ReceiptFilter.Builder, ReceiptFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ReceiptFilter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ReceiptIpFilter> IP_FILTER_FIELD = SdkField.<ReceiptIpFilter> builder(MarshallingType.SDK_POJO)
            .memberName("IpFilter").getter(getter(ReceiptFilter::ipFilter)).setter(setter(Builder::ipFilter))
            .constructor(ReceiptIpFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IP_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("IpFilter", IP_FILTER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ReceiptIpFilter ipFilter;

    private ReceiptFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.ipFilter = builder.ipFilter;
    }

    /**
     * <p>
     * The name of the IP address filter. The name must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start and end with a letter or number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Contain 64 characters or fewer.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the IP address filter. The name must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start and end with a letter or number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Contain 64 characters or fewer.
     *         </p>
     *         </li>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail from
     * them.
     * </p>
     * 
     * @return A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
     *         from them.
     */
    public final ReceiptIpFilter ipFilter() {
        return ipFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptFilter)) {
            return false;
        }
        ReceiptFilter other = (ReceiptFilter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ipFilter(), other.ipFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReceiptFilter").add("Name", name()).add("IpFilter", ipFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IpFilter":
            return Optional.ofNullable(clazz.cast(ipFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReceiptFilter, T> g) {
        return obj -> g.apply((ReceiptFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReceiptFilter> {
        /**
         * <p>
         * The name of the IP address filter. The name must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start and end with a letter or number.
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain 64 characters or fewer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the IP address filter. The name must meet the following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start and end with a letter or number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain 64 characters or fewer.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
         * from them.
         * </p>
         * 
         * @param ipFilter
         *        A structure that provides the IP addresses to block or allow, and whether to block or allow incoming
         *        mail from them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipFilter(ReceiptIpFilter ipFilter);

        /**
         * <p>
         * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
         * from them.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReceiptIpFilter.Builder} avoiding the
         * need to create one manually via {@link ReceiptIpFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReceiptIpFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #ipFilter(ReceiptIpFilter)}.
         * 
         * @param ipFilter
         *        a consumer that will call methods on {@link ReceiptIpFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipFilter(ReceiptIpFilter)
         */
        default Builder ipFilter(Consumer<ReceiptIpFilter.Builder> ipFilter) {
            return ipFilter(ReceiptIpFilter.builder().applyMutation(ipFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ReceiptIpFilter ipFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptFilter model) {
            name(model.name);
            ipFilter(model.ipFilter);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ReceiptIpFilter.Builder getIpFilter() {
            return ipFilter != null ? ipFilter.toBuilder() : null;
        }

        public final void setIpFilter(ReceiptIpFilter.BuilderImpl ipFilter) {
            this.ipFilter = ipFilter != null ? ipFilter.build() : null;
        }

        @Override
        public final Builder ipFilter(ReceiptIpFilter ipFilter) {
            this.ipFilter = ipFilter;
            return this;
        }

        @Override
        public ReceiptFilter build() {
            return new ReceiptFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
