/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.model.ReceiptActionsListCopier;
import software.amazon.awssdk.services.ses.model.RecipientsListCopier;
import software.amazon.awssdk.services.ses.model.TlsPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReceiptRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReceiptRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ReceiptRule.getter(ReceiptRule::name)).setter(ReceiptRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(ReceiptRule.getter(ReceiptRule::enabled)).setter(ReceiptRule.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> TLS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlsPolicy").getter(ReceiptRule.getter(ReceiptRule::tlsPolicyAsString)).setter(ReceiptRule.setter(Builder::tlsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsPolicy").build()}).build();
    private static final SdkField<List<String>> RECIPIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recipients").getter(ReceiptRule.getter(ReceiptRule::recipients)).setter(ReceiptRule.setter(Builder::recipients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipients").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReceiptAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(ReceiptRule.getter(ReceiptRule::actions)).setter(ReceiptRule.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReceiptAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SCAN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ScanEnabled").getter(ReceiptRule.getter(ReceiptRule::scanEnabled)).setter(ReceiptRule.setter(Builder::scanEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENABLED_FIELD, TLS_POLICY_FIELD, RECIPIENTS_FIELD, ACTIONS_FIELD, SCAN_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("TlsPolicy", TLS_POLICY_FIELD);
            this.put("Recipients", RECIPIENTS_FIELD);
            this.put("Actions", ACTIONS_FIELD);
            this.put("ScanEnabled", SCAN_ENABLED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Boolean enabled;
    private final String tlsPolicy;
    private final List<String> recipients;
    private final List<ReceiptAction> actions;
    private final Boolean scanEnabled;

    private ReceiptRule(BuilderImpl builder) {
        this.name = builder.name;
        this.enabled = builder.enabled;
        this.tlsPolicy = builder.tlsPolicy;
        this.recipients = builder.recipients;
        this.actions = builder.actions;
        this.scanEnabled = builder.scanEnabled;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final TlsPolicy tlsPolicy() {
        return TlsPolicy.fromValue(this.tlsPolicy);
    }

    public final String tlsPolicyAsString() {
        return this.tlsPolicy;
    }

    public final boolean hasRecipients() {
        return this.recipients != null && !(this.recipients instanceof SdkAutoConstructList);
    }

    public final List<String> recipients() {
        return this.recipients;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<ReceiptAction> actions() {
        return this.actions;
    }

    public final Boolean scanEnabled() {
        return this.scanEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecipients() ? this.recipients() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptRule)) {
            return false;
        }
        ReceiptRule other = (ReceiptRule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.tlsPolicyAsString(), other.tlsPolicyAsString()) && this.hasRecipients() == other.hasRecipients() && Objects.equals(this.recipients(), other.recipients()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.scanEnabled(), other.scanEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"ReceiptRule").add("Name", (Object)this.name()).add("Enabled", (Object)this.enabled()).add("TlsPolicy", (Object)this.tlsPolicyAsString()).add("Recipients", this.hasRecipients() ? this.recipients() : null).add("Actions", this.hasActions() ? this.actions() : null).add("ScanEnabled", (Object)this.scanEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "TlsPolicy": {
                return Optional.ofNullable(clazz.cast(this.tlsPolicyAsString()));
            }
            case "Recipients": {
                return Optional.ofNullable(clazz.cast(this.recipients()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "ScanEnabled": {
                return Optional.ofNullable(clazz.cast(this.scanEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReceiptRule, T> g) {
        return obj -> g.apply((ReceiptRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean enabled;
        private String tlsPolicy;
        private List<String> recipients = DefaultSdkAutoConstructList.getInstance();
        private List<ReceiptAction> actions = DefaultSdkAutoConstructList.getInstance();
        private Boolean scanEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptRule model) {
            this.name(model.name);
            this.enabled(model.enabled);
            this.tlsPolicy(model.tlsPolicy);
            this.recipients(model.recipients);
            this.actions(model.actions);
            this.scanEnabled(model.scanEnabled);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getTlsPolicy() {
            return this.tlsPolicy;
        }

        public final void setTlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
        }

        @Override
        public final Builder tlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        @Override
        public final Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy == null ? null : tlsPolicy.toString());
            return this;
        }

        public final Collection<String> getRecipients() {
            if (this.recipients instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recipients;
        }

        public final void setRecipients(Collection<String> recipients) {
            this.recipients = RecipientsListCopier.copy(recipients);
        }

        @Override
        public final Builder recipients(Collection<String> recipients) {
            this.recipients = RecipientsListCopier.copy(recipients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipients(String ... recipients) {
            this.recipients(Arrays.asList(recipients));
            return this;
        }

        public final List<ReceiptAction.Builder> getActions() {
            List<ReceiptAction.Builder> result = ReceiptActionsListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ReceiptAction.BuilderImpl> actions) {
            this.actions = ReceiptActionsListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ReceiptAction> actions) {
            this.actions = ReceiptActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ReceiptAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ReceiptAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (ReceiptAction)((ReceiptAction.Builder)ReceiptAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getScanEnabled() {
            return this.scanEnabled;
        }

        public final void setScanEnabled(Boolean scanEnabled) {
            this.scanEnabled = scanEnabled;
        }

        @Override
        public final Builder scanEnabled(Boolean scanEnabled) {
            this.scanEnabled = scanEnabled;
            return this;
        }

        public ReceiptRule build() {
            return new ReceiptRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReceiptRule> {
        public Builder name(String var1);

        public Builder enabled(Boolean var1);

        public Builder tlsPolicy(String var1);

        public Builder tlsPolicy(TlsPolicy var1);

        public Builder recipients(Collection<String> var1);

        public Builder recipients(String ... var1);

        public Builder actions(Collection<ReceiptAction> var1);

        public Builder actions(ReceiptAction ... var1);

        public Builder actions(Consumer<ReceiptAction.Builder> ... var1);

        public Builder scanEnabled(Boolean var1);
    }
}

