/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.model.AccountSendingPausedException;
import software.amazon.awssdk.services.ses.model.AlreadyExistsException;
import software.amazon.awssdk.services.ses.model.CannotDeleteException;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.ConfigurationSetDoesNotExistException;
import software.amazon.awssdk.services.ses.model.ConfigurationSetSendingPausedException;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.CreateTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateTemplateResponse;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailInvalidContentException;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplateAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplateDoesNotExistException;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.EventDestinationAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.EventDestinationDoesNotExistException;
import software.amazon.awssdk.services.ses.model.FromEmailAddressNotVerifiedException;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetSendQuotaRequest;
import software.amazon.awssdk.services.ses.model.GetSendQuotaResponse;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsRequest;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse;
import software.amazon.awssdk.services.ses.model.GetTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetTemplateResponse;
import software.amazon.awssdk.services.ses.model.InvalidCloudWatchDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidConfigurationSetException;
import software.amazon.awssdk.services.ses.model.InvalidDeliveryOptionsException;
import software.amazon.awssdk.services.ses.model.InvalidFirehoseDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidLambdaFunctionException;
import software.amazon.awssdk.services.ses.model.InvalidPolicyException;
import software.amazon.awssdk.services.ses.model.InvalidRenderingParameterException;
import software.amazon.awssdk.services.ses.model.InvalidS3ConfigurationException;
import software.amazon.awssdk.services.ses.model.InvalidSnsDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidSnsTopicException;
import software.amazon.awssdk.services.ses.model.InvalidTemplateException;
import software.amazon.awssdk.services.ses.model.InvalidTrackingOptionsException;
import software.amazon.awssdk.services.ses.model.LimitExceededException;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse;
import software.amazon.awssdk.services.ses.model.ListTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesRequest;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse;
import software.amazon.awssdk.services.ses.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.ses.model.MessageRejectedException;
import software.amazon.awssdk.services.ses.model.MissingRenderingAttributeException;
import software.amazon.awssdk.services.ses.model.ProductionAccessNotGrantedException;
import software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.RuleDoesNotExistException;
import software.amazon.awssdk.services.ses.model.RuleSetDoesNotExistException;
import software.amazon.awssdk.services.ses.model.SendBounceRequest;
import software.amazon.awssdk.services.ses.model.SendBounceResponse;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendEmailResponse;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailResponse;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SesException;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicResponse;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionResponse;
import software.amazon.awssdk.services.ses.model.TemplateDoesNotExistException;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse;
import software.amazon.awssdk.services.ses.model.TrackingOptionsAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.TrackingOptionsDoesNotExistException;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityResponse;
import software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable;
import software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable;
import software.amazon.awssdk.services.ses.transform.CloneReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateReceiptFilterRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteIdentityRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteReceiptFilterRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteVerifiedEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeActiveReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetAccountSendingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityMailFromDomainAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityPoliciesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityVerificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetSendQuotaRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetSendStatisticsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListCustomVerificationEmailTemplatesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListIdentityPoliciesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListReceiptFiltersRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListReceiptRuleSetsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListVerifiedEmailAddressesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.PutConfigurationSetDeliveryOptionsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.PutIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ReorderReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendBounceRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendBulkTemplatedEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendCustomVerificationEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendRawEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendTemplatedEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetActiveReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityDkimEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityFeedbackForwardingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityHeadersInNotificationsEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityMailFromDomainRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityNotificationTopicRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetReceiptRulePositionRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.TestRenderTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateAccountSendingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetReputationMetricsEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetSendingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyDomainDkimRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyDomainIdentityRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.ses.waiters.SesWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSesClient
implements SesClient {
    private static final Logger log = Logger.loggerFor(DefaultSesClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneReceiptRuleSetResponse cloneReceiptRuleSet(CloneReceiptRuleSetRequest cloneReceiptRuleSetRequest) throws RuleSetDoesNotExistException, AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CloneReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, cloneReceiptRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CloneReceiptRuleSet");
            CloneReceiptRuleSetResponse cloneReceiptRuleSetResponse = (CloneReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CloneReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cloneReceiptRuleSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CloneReceiptRuleSetRequestMarshaller(this.protocolFactory)));
            return cloneReceiptRuleSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$cloneReceiptRuleSet$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) throws ConfigurationSetAlreadyExistsException, InvalidConfigurationSetException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSet");
            CreateConfigurationSetResponse createConfigurationSetResponse = (CreateConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationSetRequestMarshaller(this.protocolFactory)));
            return createConfigurationSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createConfigurationSet$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) throws ConfigurationSetDoesNotExistException, EventDestinationAlreadyExistsException, InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSetEventDestination");
            CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestinationResponse = (CreateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetEventDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationSetEventDestinationRequestMarshaller(this.protocolFactory)));
            return createConfigurationSetEventDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createConfigurationSetEventDestination$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationSetTrackingOptionsResponse createConfigurationSetTrackingOptions(CreateConfigurationSetTrackingOptionsRequest createConfigurationSetTrackingOptionsRequest) throws ConfigurationSetDoesNotExistException, TrackingOptionsAlreadyExistsException, InvalidTrackingOptionsException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createConfigurationSetTrackingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSetTrackingOptions");
            CreateConfigurationSetTrackingOptionsResponse createConfigurationSetTrackingOptionsResponse = (CreateConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetTrackingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationSetTrackingOptionsRequestMarshaller(this.protocolFactory)));
            return createConfigurationSetTrackingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createConfigurationSetTrackingOptions$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) throws CustomVerificationEmailTemplateAlreadyExistsException, FromEmailAddressNotVerifiedException, CustomVerificationEmailInvalidContentException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomVerificationEmailTemplate");
            CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplateResponse = (CreateCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
            return createCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createCustomVerificationEmailTemplate$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReceiptFilterResponse createReceiptFilter(CreateReceiptFilterRequest createReceiptFilterRequest) throws LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReceiptFilterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createReceiptFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReceiptFilter");
            CreateReceiptFilterResponse createReceiptFilterResponse = (CreateReceiptFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReceiptFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReceiptFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReceiptFilterRequestMarshaller(this.protocolFactory)));
            return createReceiptFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createReceiptFilter$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReceiptRuleResponse createReceiptRule(CreateReceiptRuleRequest createReceiptRuleRequest) throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException, AlreadyExistsException, RuleDoesNotExistException, RuleSetDoesNotExistException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createReceiptRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReceiptRule");
            CreateReceiptRuleResponse createReceiptRuleResponse = (CreateReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReceiptRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReceiptRuleRequestMarshaller(this.protocolFactory)));
            return createReceiptRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createReceiptRule$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReceiptRuleSetResponse createReceiptRuleSet(CreateReceiptRuleSetRequest createReceiptRuleSetRequest) throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createReceiptRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReceiptRuleSet");
            CreateReceiptRuleSetResponse createReceiptRuleSetResponse = (CreateReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReceiptRuleSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReceiptRuleSetRequestMarshaller(this.protocolFactory)));
            return createReceiptRuleSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createReceiptRuleSet$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest) throws AlreadyExistsException, InvalidTemplateException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, createTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTemplate");
            CreateTemplateResponse createTemplateResponse = (CreateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTemplateRequestMarshaller(this.protocolFactory)));
            return createTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$createTemplate$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSet");
            DeleteConfigurationSetResponse deleteConfigurationSetResponse = (DeleteConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationSetRequestMarshaller(this.protocolFactory)));
            return deleteConfigurationSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteConfigurationSet$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSetEventDestination");
            DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestinationResponse = (DeleteConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetEventDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationSetEventDestinationRequestMarshaller(this.protocolFactory)));
            return deleteConfigurationSetEventDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteConfigurationSetEventDestination$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationSetTrackingOptionsResponse deleteConfigurationSetTrackingOptions(DeleteConfigurationSetTrackingOptionsRequest deleteConfigurationSetTrackingOptionsRequest) throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteConfigurationSetTrackingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSetTrackingOptions");
            DeleteConfigurationSetTrackingOptionsResponse deleteConfigurationSetTrackingOptionsResponse = (DeleteConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetTrackingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationSetTrackingOptionsRequestMarshaller(this.protocolFactory)));
            return deleteConfigurationSetTrackingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteConfigurationSetTrackingOptions$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomVerificationEmailTemplate");
            DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplateResponse = (DeleteCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
            return deleteCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteCustomVerificationEmailTemplate$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentityResponse deleteIdentity(DeleteIdentityRequest deleteIdentityRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentity");
            DeleteIdentityResponse deleteIdentityResponse = (DeleteIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentityRequestMarshaller(this.protocolFactory)));
            return deleteIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteIdentity$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentityPolicyResponse deleteIdentityPolicy(DeleteIdentityPolicyRequest deleteIdentityPolicyRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteIdentityPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteIdentityPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentityPolicy");
            DeleteIdentityPolicyResponse deleteIdentityPolicyResponse = (DeleteIdentityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentityPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentityPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentityPolicyRequestMarshaller(this.protocolFactory)));
            return deleteIdentityPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteIdentityPolicy$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReceiptFilterResponse deleteReceiptFilter(DeleteReceiptFilterRequest deleteReceiptFilterRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReceiptFilterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteReceiptFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReceiptFilter");
            DeleteReceiptFilterResponse deleteReceiptFilterResponse = (DeleteReceiptFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReceiptFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReceiptFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReceiptFilterRequestMarshaller(this.protocolFactory)));
            return deleteReceiptFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteReceiptFilter$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReceiptRuleResponse deleteReceiptRule(DeleteReceiptRuleRequest deleteReceiptRuleRequest) throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteReceiptRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReceiptRule");
            DeleteReceiptRuleResponse deleteReceiptRuleResponse = (DeleteReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReceiptRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReceiptRuleRequestMarshaller(this.protocolFactory)));
            return deleteReceiptRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteReceiptRule$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReceiptRuleSetResponse deleteReceiptRuleSet(DeleteReceiptRuleSetRequest deleteReceiptRuleSetRequest) throws CannotDeleteException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteReceiptRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReceiptRuleSet");
            DeleteReceiptRuleSetResponse deleteReceiptRuleSetResponse = (DeleteReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReceiptRuleSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReceiptRuleSetRequestMarshaller(this.protocolFactory)));
            return deleteReceiptRuleSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteReceiptRuleSet$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTemplate");
            DeleteTemplateResponse deleteTemplateResponse = (DeleteTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTemplateRequestMarshaller(this.protocolFactory)));
            return deleteTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteTemplate$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVerifiedEmailAddressResponse deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteVerifiedEmailAddressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, deleteVerifiedEmailAddressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVerifiedEmailAddress");
            DeleteVerifiedEmailAddressResponse deleteVerifiedEmailAddressResponse = (DeleteVerifiedEmailAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVerifiedEmailAddress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVerifiedEmailAddressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVerifiedEmailAddressRequestMarshaller(this.protocolFactory)));
            return deleteVerifiedEmailAddressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$deleteVerifiedEmailAddress$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeActiveReceiptRuleSetResponse describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest describeActiveReceiptRuleSetRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeActiveReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, describeActiveReceiptRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeActiveReceiptRuleSet");
            DescribeActiveReceiptRuleSetResponse describeActiveReceiptRuleSetResponse = (DescribeActiveReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActiveReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeActiveReceiptRuleSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeActiveReceiptRuleSetRequestMarshaller(this.protocolFactory)));
            return describeActiveReceiptRuleSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$describeActiveReceiptRuleSet$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationSetResponse describeConfigurationSet(DescribeConfigurationSetRequest describeConfigurationSetRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeConfigurationSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, describeConfigurationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationSet");
            DescribeConfigurationSetResponse describeConfigurationSetResponse = (DescribeConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationSetRequestMarshaller(this.protocolFactory)));
            return describeConfigurationSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$describeConfigurationSet$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReceiptRuleResponse describeReceiptRule(DescribeReceiptRuleRequest describeReceiptRuleRequest) throws RuleDoesNotExistException, RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, describeReceiptRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReceiptRule");
            DescribeReceiptRuleResponse describeReceiptRuleResponse = (DescribeReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReceiptRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReceiptRuleRequestMarshaller(this.protocolFactory)));
            return describeReceiptRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$describeReceiptRule$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReceiptRuleSetResponse describeReceiptRuleSet(DescribeReceiptRuleSetRequest describeReceiptRuleSetRequest) throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, describeReceiptRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReceiptRuleSet");
            DescribeReceiptRuleSetResponse describeReceiptRuleSetResponse = (DescribeReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReceiptRuleSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReceiptRuleSetRequestMarshaller(this.protocolFactory)));
            return describeReceiptRuleSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$describeReceiptRuleSet$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountSendingEnabledResponse getAccountSendingEnabled(GetAccountSendingEnabledRequest getAccountSendingEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetAccountSendingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getAccountSendingEnabledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountSendingEnabled");
            GetAccountSendingEnabledResponse getAccountSendingEnabledResponse = (GetAccountSendingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountSendingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountSendingEnabledRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountSendingEnabledRequestMarshaller(this.protocolFactory)));
            return getAccountSendingEnabledResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getAccountSendingEnabled$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest) throws CustomVerificationEmailTemplateDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCustomVerificationEmailTemplate");
            GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplateResponse = (GetCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
            return getCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getCustomVerificationEmailTemplate$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityDkimAttributesResponse getIdentityDkimAttributes(GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityDkimAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getIdentityDkimAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityDkimAttributes");
            GetIdentityDkimAttributesResponse getIdentityDkimAttributesResponse = (GetIdentityDkimAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityDkimAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityDkimAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityDkimAttributesRequestMarshaller(this.protocolFactory)));
            return getIdentityDkimAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getIdentityDkimAttributes$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityMailFromDomainAttributesResponse getIdentityMailFromDomainAttributes(GetIdentityMailFromDomainAttributesRequest getIdentityMailFromDomainAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityMailFromDomainAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getIdentityMailFromDomainAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityMailFromDomainAttributes");
            GetIdentityMailFromDomainAttributesResponse getIdentityMailFromDomainAttributesResponse = (GetIdentityMailFromDomainAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityMailFromDomainAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityMailFromDomainAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityMailFromDomainAttributesRequestMarshaller(this.protocolFactory)));
            return getIdentityMailFromDomainAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getIdentityMailFromDomainAttributes$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityNotificationAttributesResponse getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityNotificationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getIdentityNotificationAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityNotificationAttributes");
            GetIdentityNotificationAttributesResponse getIdentityNotificationAttributesResponse = (GetIdentityNotificationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityNotificationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityNotificationAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityNotificationAttributesRequestMarshaller(this.protocolFactory)));
            return getIdentityNotificationAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getIdentityNotificationAttributes$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityPoliciesResponse getIdentityPolicies(GetIdentityPoliciesRequest getIdentityPoliciesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getIdentityPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityPolicies");
            GetIdentityPoliciesResponse getIdentityPoliciesResponse = (GetIdentityPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityPoliciesRequestMarshaller(this.protocolFactory)));
            return getIdentityPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getIdentityPolicies$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityVerificationAttributesResponse getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityVerificationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getIdentityVerificationAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityVerificationAttributes");
            GetIdentityVerificationAttributesResponse getIdentityVerificationAttributesResponse = (GetIdentityVerificationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityVerificationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityVerificationAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityVerificationAttributesRequestMarshaller(this.protocolFactory)));
            return getIdentityVerificationAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getIdentityVerificationAttributes$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSendQuotaResponse getSendQuota(GetSendQuotaRequest getSendQuotaRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSendQuotaResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getSendQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSendQuota");
            GetSendQuotaResponse getSendQuotaResponse = (GetSendQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSendQuota").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSendQuotaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSendQuotaRequestMarshaller(this.protocolFactory)));
            return getSendQuotaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getSendQuota$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSendStatisticsResponse getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSendStatisticsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getSendStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSendStatistics");
            GetSendStatisticsResponse getSendStatisticsResponse = (GetSendStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSendStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSendStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSendStatisticsRequestMarshaller(this.protocolFactory)));
            return getSendStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getSendStatistics$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws TemplateDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, getTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemplate");
            GetTemplateResponse getTemplateResponse = (GetTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTemplateRequestMarshaller(this.protocolFactory)));
            return getTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$getTemplate$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListConfigurationSetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listConfigurationSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigurationSets");
            ListConfigurationSetsResponse listConfigurationSetsResponse = (ListConfigurationSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConfigurationSetsRequestMarshaller(this.protocolFactory)));
            return listConfigurationSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listConfigurationSets$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListCustomVerificationEmailTemplatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listCustomVerificationEmailTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomVerificationEmailTemplates");
            ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplatesResponse = (ListCustomVerificationEmailTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomVerificationEmailTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomVerificationEmailTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomVerificationEmailTemplatesRequestMarshaller(this.protocolFactory)));
            return listCustomVerificationEmailTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listCustomVerificationEmailTemplates$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomVerificationEmailTemplatesIterable listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) throws AwsServiceException, SdkClientException, SesException {
        return new ListCustomVerificationEmailTemplatesIterable(this, this.applyPaginatorUserAgent(listCustomVerificationEmailTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentitiesResponse listIdentities(ListIdentitiesRequest listIdentitiesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListIdentitiesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentities");
            ListIdentitiesResponse listIdentitiesResponse = (ListIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentitiesRequestMarshaller(this.protocolFactory)));
            return listIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listIdentities$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIdentitiesIterable listIdentitiesPaginator(ListIdentitiesRequest listIdentitiesRequest) throws AwsServiceException, SdkClientException, SesException {
        return new ListIdentitiesIterable(this, this.applyPaginatorUserAgent(listIdentitiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoliciesResponse listIdentityPolicies(ListIdentityPoliciesRequest listIdentityPoliciesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListIdentityPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listIdentityPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityPolicies");
            ListIdentityPoliciesResponse listIdentityPoliciesResponse = (ListIdentityPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentityPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentityPoliciesRequestMarshaller(this.protocolFactory)));
            return listIdentityPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listIdentityPolicies$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReceiptFiltersResponse listReceiptFilters(ListReceiptFiltersRequest listReceiptFiltersRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListReceiptFiltersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listReceiptFiltersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceiptFilters");
            ListReceiptFiltersResponse listReceiptFiltersResponse = (ListReceiptFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceiptFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceiptFiltersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReceiptFiltersRequestMarshaller(this.protocolFactory)));
            return listReceiptFiltersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listReceiptFilters$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReceiptRuleSetsResponse listReceiptRuleSets(ListReceiptRuleSetsRequest listReceiptRuleSetsRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListReceiptRuleSetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listReceiptRuleSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceiptRuleSets");
            ListReceiptRuleSetsResponse listReceiptRuleSetsResponse = (ListReceiptRuleSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceiptRuleSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceiptRuleSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReceiptRuleSetsRequestMarshaller(this.protocolFactory)));
            return listReceiptRuleSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listReceiptRuleSets$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTemplatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTemplates");
            ListTemplatesResponse listTemplatesResponse = (ListTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTemplatesRequestMarshaller(this.protocolFactory)));
            return listTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listTemplates$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVerifiedEmailAddressesResponse listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListVerifiedEmailAddressesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, listVerifiedEmailAddressesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVerifiedEmailAddresses");
            ListVerifiedEmailAddressesResponse listVerifiedEmailAddressesResponse = (ListVerifiedEmailAddressesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVerifiedEmailAddresses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVerifiedEmailAddressesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVerifiedEmailAddressesRequestMarshaller(this.protocolFactory)));
            return listVerifiedEmailAddressesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$listVerifiedEmailAddresses$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) throws ConfigurationSetDoesNotExistException, InvalidDeliveryOptionsException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutConfigurationSetDeliveryOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, putConfigurationSetDeliveryOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetDeliveryOptions");
            PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptionsResponse = (PutConfigurationSetDeliveryOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetDeliveryOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetDeliveryOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetDeliveryOptionsRequestMarshaller(this.protocolFactory)));
            return putConfigurationSetDeliveryOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$putConfigurationSetDeliveryOptions$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutIdentityPolicyResponse putIdentityPolicy(PutIdentityPolicyRequest putIdentityPolicyRequest) throws InvalidPolicyException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutIdentityPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, putIdentityPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutIdentityPolicy");
            PutIdentityPolicyResponse putIdentityPolicyResponse = (PutIdentityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutIdentityPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putIdentityPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutIdentityPolicyRequestMarshaller(this.protocolFactory)));
            return putIdentityPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$putIdentityPolicy$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReorderReceiptRuleSetResponse reorderReceiptRuleSet(ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest) throws RuleSetDoesNotExistException, RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ReorderReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, reorderReceiptRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReorderReceiptRuleSet");
            ReorderReceiptRuleSetResponse reorderReceiptRuleSetResponse = (ReorderReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReorderReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reorderReceiptRuleSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReorderReceiptRuleSetRequestMarshaller(this.protocolFactory)));
            return reorderReceiptRuleSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$reorderReceiptRuleSet$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendBounceResponse sendBounce(SendBounceRequest sendBounceRequest) throws MessageRejectedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendBounceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, sendBounceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendBounce");
            SendBounceResponse sendBounceResponse = (SendBounceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendBounce").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendBounceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendBounceRequestMarshaller(this.protocolFactory)));
            return sendBounceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$sendBounce$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendBulkTemplatedEmailResponse sendBulkTemplatedEmail(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, TemplateDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendBulkTemplatedEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, sendBulkTemplatedEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendBulkTemplatedEmail");
            SendBulkTemplatedEmailResponse sendBulkTemplatedEmailResponse = (SendBulkTemplatedEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendBulkTemplatedEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendBulkTemplatedEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendBulkTemplatedEmailRequestMarshaller(this.protocolFactory)));
            return sendBulkTemplatedEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$sendBulkTemplatedEmail$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendCustomVerificationEmailResponse sendCustomVerificationEmail(SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) throws MessageRejectedException, ConfigurationSetDoesNotExistException, CustomVerificationEmailTemplateDoesNotExistException, FromEmailAddressNotVerifiedException, ProductionAccessNotGrantedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendCustomVerificationEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, sendCustomVerificationEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendCustomVerificationEmail");
            SendCustomVerificationEmailResponse sendCustomVerificationEmailResponse = (SendCustomVerificationEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendCustomVerificationEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendCustomVerificationEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendCustomVerificationEmailRequestMarshaller(this.protocolFactory)));
            return sendCustomVerificationEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$sendCustomVerificationEmail$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, sendEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendEmail");
            SendEmailResponse sendEmailResponse = (SendEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendEmailRequestMarshaller(this.protocolFactory)));
            return sendEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$sendEmail$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendRawEmailResponse sendRawEmail(SendRawEmailRequest sendRawEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendRawEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, sendRawEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendRawEmail");
            SendRawEmailResponse sendRawEmailResponse = (SendRawEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendRawEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendRawEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendRawEmailRequestMarshaller(this.protocolFactory)));
            return sendRawEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$sendRawEmail$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTemplatedEmailResponse sendTemplatedEmail(SendTemplatedEmailRequest sendTemplatedEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, TemplateDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendTemplatedEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, sendTemplatedEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTemplatedEmail");
            SendTemplatedEmailResponse sendTemplatedEmailResponse = (SendTemplatedEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTemplatedEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendTemplatedEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendTemplatedEmailRequestMarshaller(this.protocolFactory)));
            return sendTemplatedEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$sendTemplatedEmail$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetActiveReceiptRuleSetResponse setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest setActiveReceiptRuleSetRequest) throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetActiveReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, setActiveReceiptRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetActiveReceiptRuleSet");
            SetActiveReceiptRuleSetResponse setActiveReceiptRuleSetResponse = (SetActiveReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetActiveReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setActiveReceiptRuleSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetActiveReceiptRuleSetRequestMarshaller(this.protocolFactory)));
            return setActiveReceiptRuleSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$setActiveReceiptRuleSet$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityDkimEnabledResponse setIdentityDkimEnabled(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityDkimEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, setIdentityDkimEnabledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityDkimEnabled");
            SetIdentityDkimEnabledResponse setIdentityDkimEnabledResponse = (SetIdentityDkimEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityDkimEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityDkimEnabledRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityDkimEnabledRequestMarshaller(this.protocolFactory)));
            return setIdentityDkimEnabledResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$setIdentityDkimEnabled$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityFeedbackForwardingEnabledResponse setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityFeedbackForwardingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, setIdentityFeedbackForwardingEnabledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityFeedbackForwardingEnabled");
            SetIdentityFeedbackForwardingEnabledResponse setIdentityFeedbackForwardingEnabledResponse = (SetIdentityFeedbackForwardingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityFeedbackForwardingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityFeedbackForwardingEnabledRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityFeedbackForwardingEnabledRequestMarshaller(this.protocolFactory)));
            return setIdentityFeedbackForwardingEnabledResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$setIdentityFeedbackForwardingEnabled$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityHeadersInNotificationsEnabledResponse setIdentityHeadersInNotificationsEnabled(SetIdentityHeadersInNotificationsEnabledRequest setIdentityHeadersInNotificationsEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityHeadersInNotificationsEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, setIdentityHeadersInNotificationsEnabledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityHeadersInNotificationsEnabled");
            SetIdentityHeadersInNotificationsEnabledResponse setIdentityHeadersInNotificationsEnabledResponse = (SetIdentityHeadersInNotificationsEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityHeadersInNotificationsEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityHeadersInNotificationsEnabledRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityHeadersInNotificationsEnabledRequestMarshaller(this.protocolFactory)));
            return setIdentityHeadersInNotificationsEnabledResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$setIdentityHeadersInNotificationsEnabled$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityMailFromDomainResponse setIdentityMailFromDomain(SetIdentityMailFromDomainRequest setIdentityMailFromDomainRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityMailFromDomainResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, setIdentityMailFromDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityMailFromDomain");
            SetIdentityMailFromDomainResponse setIdentityMailFromDomainResponse = (SetIdentityMailFromDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityMailFromDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityMailFromDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityMailFromDomainRequestMarshaller(this.protocolFactory)));
            return setIdentityMailFromDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$setIdentityMailFromDomain$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityNotificationTopicResponse setIdentityNotificationTopic(SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityNotificationTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, setIdentityNotificationTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityNotificationTopic");
            SetIdentityNotificationTopicResponse setIdentityNotificationTopicResponse = (SetIdentityNotificationTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityNotificationTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityNotificationTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityNotificationTopicRequestMarshaller(this.protocolFactory)));
            return setIdentityNotificationTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$setIdentityNotificationTopic$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetReceiptRulePositionResponse setReceiptRulePosition(SetReceiptRulePositionRequest setReceiptRulePositionRequest) throws RuleSetDoesNotExistException, RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetReceiptRulePositionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, setReceiptRulePositionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetReceiptRulePosition");
            SetReceiptRulePositionResponse setReceiptRulePositionResponse = (SetReceiptRulePositionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetReceiptRulePosition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setReceiptRulePositionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetReceiptRulePositionRequestMarshaller(this.protocolFactory)));
            return setReceiptRulePositionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$setReceiptRulePosition$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestRenderTemplateResponse testRenderTemplate(TestRenderTemplateRequest testRenderTemplateRequest) throws TemplateDoesNotExistException, InvalidRenderingParameterException, MissingRenderingAttributeException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TestRenderTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, testRenderTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestRenderTemplate");
            TestRenderTemplateResponse testRenderTemplateResponse = (TestRenderTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestRenderTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testRenderTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestRenderTemplateRequestMarshaller(this.protocolFactory)));
            return testRenderTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$testRenderTemplate$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccountSendingEnabledResponse updateAccountSendingEnabled(UpdateAccountSendingEnabledRequest updateAccountSendingEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAccountSendingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateAccountSendingEnabledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountSendingEnabled");
            UpdateAccountSendingEnabledResponse updateAccountSendingEnabledResponse = (UpdateAccountSendingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountSendingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAccountSendingEnabledRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccountSendingEnabledRequestMarshaller(this.protocolFactory)));
            return updateAccountSendingEnabledResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateAccountSendingEnabled$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException, InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfigurationSetEventDestination");
            UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestinationResponse = (UpdateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetEventDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationSetEventDestinationRequestMarshaller(this.protocolFactory)));
            return updateConfigurationSetEventDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateConfigurationSetEventDestination$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationSetReputationMetricsEnabledResponse updateConfigurationSetReputationMetricsEnabled(UpdateConfigurationSetReputationMetricsEnabledRequest updateConfigurationSetReputationMetricsEnabledRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetReputationMetricsEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateConfigurationSetReputationMetricsEnabledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfigurationSetReputationMetricsEnabled");
            UpdateConfigurationSetReputationMetricsEnabledResponse updateConfigurationSetReputationMetricsEnabledResponse = (UpdateConfigurationSetReputationMetricsEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetReputationMetricsEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetReputationMetricsEnabledRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationSetReputationMetricsEnabledRequestMarshaller(this.protocolFactory)));
            return updateConfigurationSetReputationMetricsEnabledResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateConfigurationSetReputationMetricsEnabled$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationSetSendingEnabledResponse updateConfigurationSetSendingEnabled(UpdateConfigurationSetSendingEnabledRequest updateConfigurationSetSendingEnabledRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetSendingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateConfigurationSetSendingEnabledRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfigurationSetSendingEnabled");
            UpdateConfigurationSetSendingEnabledResponse updateConfigurationSetSendingEnabledResponse = (UpdateConfigurationSetSendingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetSendingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetSendingEnabledRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationSetSendingEnabledRequestMarshaller(this.protocolFactory)));
            return updateConfigurationSetSendingEnabledResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateConfigurationSetSendingEnabled$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationSetTrackingOptionsResponse updateConfigurationSetTrackingOptions(UpdateConfigurationSetTrackingOptionsRequest updateConfigurationSetTrackingOptionsRequest) throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, InvalidTrackingOptionsException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateConfigurationSetTrackingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfigurationSetTrackingOptions");
            UpdateConfigurationSetTrackingOptionsResponse updateConfigurationSetTrackingOptionsResponse = (UpdateConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetTrackingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationSetTrackingOptionsRequestMarshaller(this.protocolFactory)));
            return updateConfigurationSetTrackingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateConfigurationSetTrackingOptions$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) throws CustomVerificationEmailTemplateDoesNotExistException, FromEmailAddressNotVerifiedException, CustomVerificationEmailInvalidContentException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateCustomVerificationEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomVerificationEmailTemplate");
            UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplateResponse = (UpdateCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCustomVerificationEmailTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
            return updateCustomVerificationEmailTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateCustomVerificationEmailTemplate$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReceiptRuleResponse updateReceiptRule(UpdateReceiptRuleRequest updateReceiptRuleRequest) throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException, RuleSetDoesNotExistException, RuleDoesNotExistException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateReceiptRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReceiptRule");
            UpdateReceiptRuleResponse updateReceiptRuleResponse = (UpdateReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateReceiptRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReceiptRuleRequestMarshaller(this.protocolFactory)));
            return updateReceiptRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateReceiptRule$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTemplateResponse updateTemplate(UpdateTemplateRequest updateTemplateRequest) throws TemplateDoesNotExistException, InvalidTemplateException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, updateTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTemplate");
            UpdateTemplateResponse updateTemplateResponse = (UpdateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTemplateRequestMarshaller(this.protocolFactory)));
            return updateTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$updateTemplate$66((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyDomainDkimResponse verifyDomainDkim(VerifyDomainDkimRequest verifyDomainDkimRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyDomainDkimResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, verifyDomainDkimRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyDomainDkim");
            VerifyDomainDkimResponse verifyDomainDkimResponse = (VerifyDomainDkimResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyDomainDkim").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyDomainDkimRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyDomainDkimRequestMarshaller(this.protocolFactory)));
            return verifyDomainDkimResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$verifyDomainDkim$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyDomainIdentityResponse verifyDomainIdentity(VerifyDomainIdentityRequest verifyDomainIdentityRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyDomainIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, verifyDomainIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyDomainIdentity");
            VerifyDomainIdentityResponse verifyDomainIdentityResponse = (VerifyDomainIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyDomainIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyDomainIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyDomainIdentityRequestMarshaller(this.protocolFactory)));
            return verifyDomainIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$verifyDomainIdentity$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyEmailAddressResponse verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyEmailAddressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, verifyEmailAddressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyEmailAddress");
            VerifyEmailAddressResponse verifyEmailAddressResponse = (VerifyEmailAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyEmailAddress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyEmailAddressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyEmailAddressRequestMarshaller(this.protocolFactory)));
            return verifyEmailAddressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$verifyEmailAddress$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyEmailIdentityResponse verifyEmailIdentity(VerifyEmailIdentityRequest verifyEmailIdentityRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyEmailIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSesClient.resolveMetricPublishers(this.clientConfiguration, verifyEmailIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SES");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyEmailIdentity");
            VerifyEmailIdentityResponse verifyEmailIdentityResponse = (VerifyEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyEmailIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyEmailIdentityRequestMarshaller(this.protocolFactory)));
            return verifyEmailIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSesClient.lambda$verifyEmailIdentity$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SesWaiter waiter() {
        return SesWaiter.builder().client(this).build();
    }

    private <T extends SesRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.20").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SesRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "ses";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFirehoseDestination").exceptionBuilderSupplier(InvalidFirehoseDestinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3Configuration").exceptionBuilderSupplier(InvalidS3ConfigurationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDeliveryOptions").exceptionBuilderSupplier(InvalidDeliveryOptionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRenderingParameter").exceptionBuilderSupplier(InvalidRenderingParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSNSDestination").exceptionBuilderSupplier(InvalidSnsDestinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MessageRejected").exceptionBuilderSupplier(MessageRejectedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCloudWatchDestination").exceptionBuilderSupplier(InvalidCloudWatchDestinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountSendingPausedException").exceptionBuilderSupplier(AccountSendingPausedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RuleSetDoesNotExist").exceptionBuilderSupplier(RuleSetDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnsTopic").exceptionBuilderSupplier(InvalidSnsTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConfigurationSetSendingPausedException").exceptionBuilderSupplier(ConfigurationSetSendingPausedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDestinationDoesNotExist").exceptionBuilderSupplier(EventDestinationDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLambdaFunction").exceptionBuilderSupplier(InvalidLambdaFunctionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TemplateDoesNotExist").exceptionBuilderSupplier(TemplateDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingRenderingAttribute").exceptionBuilderSupplier(MissingRenderingAttributeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExists").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotDelete").exceptionBuilderSupplier(CannotDeleteException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrackingOptionsAlreadyExistsException").exceptionBuilderSupplier(TrackingOptionsAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConfigurationSetAlreadyExists").exceptionBuilderSupplier(ConfigurationSetAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomVerificationEmailInvalidContent").exceptionBuilderSupplier(CustomVerificationEmailInvalidContentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTemplate").exceptionBuilderSupplier(InvalidTemplateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConfigurationSetDoesNotExist").exceptionBuilderSupplier(ConfigurationSetDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProductionAccessNotGranted").exceptionBuilderSupplier(ProductionAccessNotGrantedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTrackingOptions").exceptionBuilderSupplier(InvalidTrackingOptionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrackingOptionsDoesNotExistException").exceptionBuilderSupplier(TrackingOptionsDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDestinationAlreadyExists").exceptionBuilderSupplier(EventDestinationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FromEmailAddressNotVerified").exceptionBuilderSupplier(FromEmailAddressNotVerifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RuleDoesNotExist").exceptionBuilderSupplier(RuleDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationSet").exceptionBuilderSupplier(InvalidConfigurationSetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomVerificationEmailTemplateDoesNotExist").exceptionBuilderSupplier(CustomVerificationEmailTemplateDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPolicy").exceptionBuilderSupplier(InvalidPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomVerificationEmailTemplateAlreadyExists").exceptionBuilderSupplier(CustomVerificationEmailTemplateAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SesException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$verifyEmailIdentity$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyEmailAddress$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyDomainIdentity$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyDomainDkim$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTemplate$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReceiptRule$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomVerificationEmailTemplate$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfigurationSetTrackingOptions$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfigurationSetSendingEnabled$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfigurationSetReputationMetricsEnabled$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfigurationSetEventDestination$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountSendingEnabled$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testRenderTemplate$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setReceiptRulePosition$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityNotificationTopic$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityMailFromDomain$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityHeadersInNotificationsEnabled$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityFeedbackForwardingEnabled$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityDkimEnabled$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setActiveReceiptRuleSet$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTemplatedEmail$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendRawEmail$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendEmail$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendCustomVerificationEmail$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendBulkTemplatedEmail$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendBounce$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$reorderReceiptRuleSet$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putIdentityPolicy$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfigurationSetDeliveryOptions$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVerifiedEmailAddresses$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTemplates$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceiptRuleSets$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceiptFilters$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityPolicies$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentities$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomVerificationEmailTemplates$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfigurationSets$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemplate$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSendStatistics$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSendQuota$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityVerificationAttributes$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityPolicies$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityNotificationAttributes$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityMailFromDomainAttributes$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityDkimAttributes$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCustomVerificationEmailTemplate$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountSendingEnabled$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReceiptRuleSet$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReceiptRule$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConfigurationSet$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeActiveReceiptRuleSet$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVerifiedEmailAddress$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTemplate$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReceiptRuleSet$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReceiptRule$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReceiptFilter$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentityPolicy$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentity$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomVerificationEmailTemplate$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfigurationSetTrackingOptions$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfigurationSetEventDestination$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfigurationSet$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTemplate$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReceiptRuleSet$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReceiptRule$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReceiptFilter$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomVerificationEmailTemplate$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfigurationSetTrackingOptions$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfigurationSetEventDestination$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfigurationSet$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cloneReceiptRuleSet$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

