/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.BulkEmailStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BulkEmailDestinationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BulkEmailDestinationStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(BulkEmailDestinationStatus.getter(BulkEmailDestinationStatus::statusAsString)).setter(BulkEmailDestinationStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(BulkEmailDestinationStatus.getter(BulkEmailDestinationStatus::error)).setter(BulkEmailDestinationStatus.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(BulkEmailDestinationStatus.getter(BulkEmailDestinationStatus::messageId)).setter(BulkEmailDestinationStatus.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ERROR_FIELD, MESSAGE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String error;
    private final String messageId;

    private BulkEmailDestinationStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.error = builder.error;
        this.messageId = builder.messageId;
    }

    public final BulkEmailStatus status() {
        return BulkEmailStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String error() {
        return this.error;
    }

    public final String messageId() {
        return this.messageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailDestinationStatus)) {
            return false;
        }
        BulkEmailDestinationStatus other = (BulkEmailDestinationStatus)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.messageId(), other.messageId());
    }

    public final String toString() {
        return ToString.builder((String)"BulkEmailDestinationStatus").add("Status", (Object)this.statusAsString()).add("Error", (Object)this.error()).add("MessageId", (Object)this.messageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkEmailDestinationStatus, T> g) {
        return obj -> g.apply((BulkEmailDestinationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String error;
        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailDestinationStatus model) {
            this.status(model.status);
            this.error(model.error);
            this.messageId(model.messageId);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BulkEmailStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public BulkEmailDestinationStatus build() {
            return new BulkEmailDestinationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BulkEmailDestinationStatus> {
        public Builder status(String var1);

        public Builder status(BulkEmailStatus var1);

        public Builder error(String var1);

        public Builder messageId(String var1);
    }
}

