/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.VerificationStatus;
import software.amazon.awssdk.services.ses.model.VerificationTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityDkimAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityDkimAttributes> {
    private static final SdkField<Boolean> DKIM_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DkimEnabled").getter(IdentityDkimAttributes.getter(IdentityDkimAttributes::dkimEnabled)).setter(IdentityDkimAttributes.setter(Builder::dkimEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimEnabled").build()}).build();
    private static final SdkField<String> DKIM_VERIFICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DkimVerificationStatus").getter(IdentityDkimAttributes.getter(IdentityDkimAttributes::dkimVerificationStatusAsString)).setter(IdentityDkimAttributes.setter(Builder::dkimVerificationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimVerificationStatus").build()}).build();
    private static final SdkField<List<String>> DKIM_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DkimTokens").getter(IdentityDkimAttributes.getter(IdentityDkimAttributes::dkimTokens)).setter(IdentityDkimAttributes.setter(Builder::dkimTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DKIM_ENABLED_FIELD, DKIM_VERIFICATION_STATUS_FIELD, DKIM_TOKENS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean dkimEnabled;
    private final String dkimVerificationStatus;
    private final List<String> dkimTokens;

    private IdentityDkimAttributes(BuilderImpl builder) {
        this.dkimEnabled = builder.dkimEnabled;
        this.dkimVerificationStatus = builder.dkimVerificationStatus;
        this.dkimTokens = builder.dkimTokens;
    }

    public final Boolean dkimEnabled() {
        return this.dkimEnabled;
    }

    public final VerificationStatus dkimVerificationStatus() {
        return VerificationStatus.fromValue(this.dkimVerificationStatus);
    }

    public final String dkimVerificationStatusAsString() {
        return this.dkimVerificationStatus;
    }

    public final boolean hasDkimTokens() {
        return this.dkimTokens != null && !(this.dkimTokens instanceof SdkAutoConstructList);
    }

    public final List<String> dkimTokens() {
        return this.dkimTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimVerificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDkimTokens() ? this.dkimTokens() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDkimAttributes)) {
            return false;
        }
        IdentityDkimAttributes other = (IdentityDkimAttributes)obj;
        return Objects.equals(this.dkimEnabled(), other.dkimEnabled()) && Objects.equals(this.dkimVerificationStatusAsString(), other.dkimVerificationStatusAsString()) && this.hasDkimTokens() == other.hasDkimTokens() && Objects.equals(this.dkimTokens(), other.dkimTokens());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityDkimAttributes").add("DkimEnabled", (Object)this.dkimEnabled()).add("DkimVerificationStatus", (Object)this.dkimVerificationStatusAsString()).add("DkimTokens", this.hasDkimTokens() ? this.dkimTokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DkimEnabled": {
                return Optional.ofNullable(clazz.cast(this.dkimEnabled()));
            }
            case "DkimVerificationStatus": {
                return Optional.ofNullable(clazz.cast(this.dkimVerificationStatusAsString()));
            }
            case "DkimTokens": {
                return Optional.ofNullable(clazz.cast(this.dkimTokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityDkimAttributes, T> g) {
        return obj -> g.apply((IdentityDkimAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean dkimEnabled;
        private String dkimVerificationStatus;
        private List<String> dkimTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDkimAttributes model) {
            this.dkimEnabled(model.dkimEnabled);
            this.dkimVerificationStatus(model.dkimVerificationStatus);
            this.dkimTokens(model.dkimTokens);
        }

        public final Boolean getDkimEnabled() {
            return this.dkimEnabled;
        }

        public final void setDkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
        }

        @Override
        @Transient
        public final Builder dkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
            return this;
        }

        public final String getDkimVerificationStatus() {
            return this.dkimVerificationStatus;
        }

        public final void setDkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
        }

        @Override
        @Transient
        public final Builder dkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder dkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus == null ? null : dkimVerificationStatus.toString());
            return this;
        }

        public final Collection<String> getDkimTokens() {
            if (this.dkimTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dkimTokens;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        @Override
        @Transient
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dkimTokens(String ... dkimTokens) {
            this.dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public IdentityDkimAttributes build() {
            return new IdentityDkimAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityDkimAttributes> {
        public Builder dkimEnabled(Boolean var1);

        public Builder dkimVerificationStatus(String var1);

        public Builder dkimVerificationStatus(VerificationStatus var1);

        public Builder dkimTokens(Collection<String> var1);

        public Builder dkimTokens(String ... var1);
    }
}

