/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;

public class ListIdentitiesIterable
implements SdkIterable<ListIdentitiesResponse> {
    private final SesClient client;
    private final ListIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdentitiesIterable(SesClient client, ListIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIdentitiesResponseFetcher();
    }

    public Iterator<ListIdentitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> identities() {
        Function<ListIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.identities() != null) {
                return response.identities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdentitiesResponseFetcher
    implements SyncPageFetcher<ListIdentitiesResponse> {
        private ListIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdentitiesResponse nextPage(ListIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListIdentitiesIterable.this.client.listIdentities(ListIdentitiesIterable.this.firstRequest);
            }
            return ListIdentitiesIterable.this.client.listIdentities((ListIdentitiesRequest)((Object)ListIdentitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

