/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ses.model.DkimAttributesCopier;
import software.amazon.awssdk.services.ses.model.IdentityDkimAttributes;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityDkimAttributesResponse
extends SesResponse
implements ToCopyableBuilder<Builder, GetIdentityDkimAttributesResponse> {
    private static final SdkField<Map<String, IdentityDkimAttributes>> DKIM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DkimAttributes").getter(GetIdentityDkimAttributesResponse.getter(GetIdentityDkimAttributesResponse::dkimAttributes)).setter(GetIdentityDkimAttributesResponse.setter(Builder::dkimAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityDkimAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DKIM_ATTRIBUTES_FIELD));
    private final Map<String, IdentityDkimAttributes> dkimAttributes;

    private GetIdentityDkimAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.dkimAttributes = builder.dkimAttributes;
    }

    public final boolean hasDkimAttributes() {
        return this.dkimAttributes != null && !(this.dkimAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, IdentityDkimAttributes> dkimAttributes() {
        return this.dkimAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDkimAttributes() ? this.dkimAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityDkimAttributesResponse)) {
            return false;
        }
        GetIdentityDkimAttributesResponse other = (GetIdentityDkimAttributesResponse)((Object)obj);
        return this.hasDkimAttributes() == other.hasDkimAttributes() && Objects.equals(this.dkimAttributes(), other.dkimAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityDkimAttributesResponse").add("DkimAttributes", this.hasDkimAttributes() ? this.dkimAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DkimAttributes": {
                return Optional.ofNullable(clazz.cast(this.dkimAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityDkimAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityDkimAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private Map<String, IdentityDkimAttributes> dkimAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityDkimAttributesResponse model) {
            super(model);
            this.dkimAttributes(model.dkimAttributes);
        }

        public final Map<String, IdentityDkimAttributes.Builder> getDkimAttributes() {
            if (this.dkimAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dkimAttributes != null ? CollectionUtils.mapValues(this.dkimAttributes, IdentityDkimAttributes::toBuilder) : null;
        }

        @Override
        public final Builder dkimAttributes(Map<String, IdentityDkimAttributes> dkimAttributes) {
            this.dkimAttributes = DkimAttributesCopier.copy(dkimAttributes);
            return this;
        }

        public final void setDkimAttributes(Map<String, IdentityDkimAttributes.BuilderImpl> dkimAttributes) {
            this.dkimAttributes = DkimAttributesCopier.copyFromBuilder(dkimAttributes);
        }

        @Override
        public GetIdentityDkimAttributesResponse build() {
            return new GetIdentityDkimAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityDkimAttributesResponse> {
        public Builder dkimAttributes(Map<String, IdentityDkimAttributes> var1);
    }
}

