/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.InvocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaAction> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(LambdaAction.getter(LambdaAction::topicArn)).setter(LambdaAction.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(LambdaAction.getter(LambdaAction::functionArn)).setter(LambdaAction.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationType").getter(LambdaAction.getter(LambdaAction::invocationTypeAsString)).setter(LambdaAction.setter(Builder::invocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, FUNCTION_ARN_FIELD, INVOCATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topicArn;
    private final String functionArn;
    private final String invocationType;

    private LambdaAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.functionArn = builder.functionArn;
        this.invocationType = builder.invocationType;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public InvocationType invocationType() {
        return InvocationType.fromValue(this.invocationType);
    }

    public String invocationTypeAsString() {
        return this.invocationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaAction)) {
            return false;
        }
        LambdaAction other = (LambdaAction)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.invocationTypeAsString(), other.invocationTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"LambdaAction").add("TopicArn", (Object)this.topicArn()).add("FunctionArn", (Object)this.functionArn()).add("InvocationType", (Object)this.invocationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "InvocationType": {
                return Optional.ofNullable(clazz.cast(this.invocationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaAction, T> g) {
        return obj -> g.apply((LambdaAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String functionArn;
        private String invocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaAction model) {
            this.topicArn(model.topicArn);
            this.functionArn(model.functionArn);
            this.invocationType(model.invocationType);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getInvocationType() {
            return this.invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        public LambdaAction build() {
            return new LambdaAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaAction> {
        public Builder topicArn(String var1);

        public Builder functionArn(String var1);

        public Builder invocationType(String var1);

        public Builder invocationType(InvocationType var1);
    }
}

