/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendDataPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SendDataPoint> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(SendDataPoint.getter(SendDataPoint::timestamp)).setter(SendDataPoint.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Long> DELIVERY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DeliveryAttempts").getter(SendDataPoint.getter(SendDataPoint::deliveryAttempts)).setter(SendDataPoint.setter(Builder::deliveryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAttempts").build()}).build();
    private static final SdkField<Long> BOUNCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Bounces").getter(SendDataPoint.getter(SendDataPoint::bounces)).setter(SendDataPoint.setter(Builder::bounces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bounces").build()}).build();
    private static final SdkField<Long> COMPLAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Complaints").getter(SendDataPoint.getter(SendDataPoint::complaints)).setter(SendDataPoint.setter(Builder::complaints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Complaints").build()}).build();
    private static final SdkField<Long> REJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Rejects").getter(SendDataPoint.getter(SendDataPoint::rejects)).setter(SendDataPoint.setter(Builder::rejects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rejects").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, DELIVERY_ATTEMPTS_FIELD, BOUNCES_FIELD, COMPLAINTS_FIELD, REJECTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final Long deliveryAttempts;
    private final Long bounces;
    private final Long complaints;
    private final Long rejects;

    private SendDataPoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.deliveryAttempts = builder.deliveryAttempts;
        this.bounces = builder.bounces;
        this.complaints = builder.complaints;
        this.rejects = builder.rejects;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Long deliveryAttempts() {
        return this.deliveryAttempts;
    }

    public Long bounces() {
        return this.bounces;
    }

    public Long complaints() {
        return this.complaints;
    }

    public Long rejects() {
        return this.rejects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounces());
        hashCode = 31 * hashCode + Objects.hashCode(this.complaints());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejects());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataPoint)) {
            return false;
        }
        SendDataPoint other = (SendDataPoint)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.deliveryAttempts(), other.deliveryAttempts()) && Objects.equals(this.bounces(), other.bounces()) && Objects.equals(this.complaints(), other.complaints()) && Objects.equals(this.rejects(), other.rejects());
    }

    public String toString() {
        return ToString.builder((String)"SendDataPoint").add("Timestamp", (Object)this.timestamp()).add("DeliveryAttempts", (Object)this.deliveryAttempts()).add("Bounces", (Object)this.bounces()).add("Complaints", (Object)this.complaints()).add("Rejects", (Object)this.rejects()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "DeliveryAttempts": {
                return Optional.ofNullable(clazz.cast(this.deliveryAttempts()));
            }
            case "Bounces": {
                return Optional.ofNullable(clazz.cast(this.bounces()));
            }
            case "Complaints": {
                return Optional.ofNullable(clazz.cast(this.complaints()));
            }
            case "Rejects": {
                return Optional.ofNullable(clazz.cast(this.rejects()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendDataPoint, T> g) {
        return obj -> g.apply((SendDataPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Long deliveryAttempts;
        private Long bounces;
        private Long complaints;
        private Long rejects;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataPoint model) {
            this.timestamp(model.timestamp);
            this.deliveryAttempts(model.deliveryAttempts);
            this.bounces(model.bounces);
            this.complaints(model.complaints);
            this.rejects(model.rejects);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Long getDeliveryAttempts() {
            return this.deliveryAttempts;
        }

        @Override
        public final Builder deliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
            return this;
        }

        public final void setDeliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
        }

        public final Long getBounces() {
            return this.bounces;
        }

        @Override
        public final Builder bounces(Long bounces) {
            this.bounces = bounces;
            return this;
        }

        public final void setBounces(Long bounces) {
            this.bounces = bounces;
        }

        public final Long getComplaints() {
            return this.complaints;
        }

        @Override
        public final Builder complaints(Long complaints) {
            this.complaints = complaints;
            return this;
        }

        public final void setComplaints(Long complaints) {
            this.complaints = complaints;
        }

        public final Long getRejects() {
            return this.rejects;
        }

        @Override
        public final Builder rejects(Long rejects) {
            this.rejects = rejects;
            return this;
        }

        public final void setRejects(Long rejects) {
            this.rejects = rejects;
        }

        public SendDataPoint build() {
            return new SendDataPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SendDataPoint> {
        public Builder timestamp(Instant var1);

        public Builder deliveryAttempts(Long var1);

        public Builder bounces(Long var1);

        public Builder complaints(Long var1);

        public Builder rejects(Long var1);
    }
}

