/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ses.SesAsyncClient;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse;

public class ListCustomVerificationEmailTemplatesPublisher
implements SdkPublisher<ListCustomVerificationEmailTemplatesResponse> {
    private final SesAsyncClient client;
    private final ListCustomVerificationEmailTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomVerificationEmailTemplatesPublisher(SesAsyncClient client, ListCustomVerificationEmailTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomVerificationEmailTemplatesPublisher(SesAsyncClient client, ListCustomVerificationEmailTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomVerificationEmailTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomVerificationEmailTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCustomVerificationEmailTemplatesResponseFetcher
    implements AsyncPageFetcher<ListCustomVerificationEmailTemplatesResponse> {
        private ListCustomVerificationEmailTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomVerificationEmailTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomVerificationEmailTemplatesResponse> nextPage(ListCustomVerificationEmailTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCustomVerificationEmailTemplatesPublisher.this.client.listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesPublisher.this.firstRequest);
            }
            return ListCustomVerificationEmailTemplatesPublisher.this.client.listCustomVerificationEmailTemplates((ListCustomVerificationEmailTemplatesRequest)((Object)ListCustomVerificationEmailTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

