/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.BounceType;
import software.amazon.awssdk.services.ses.model.RecipientDsnFields;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BouncedRecipientInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BouncedRecipientInfo> {
    private static final SdkField<String> RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BouncedRecipientInfo.getter(BouncedRecipientInfo::recipient)).setter(BouncedRecipientInfo.setter(Builder::recipient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipient").build()}).build();
    private static final SdkField<String> RECIPIENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BouncedRecipientInfo.getter(BouncedRecipientInfo::recipientArn)).setter(BouncedRecipientInfo.setter(Builder::recipientArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipientArn").build()}).build();
    private static final SdkField<String> BOUNCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BouncedRecipientInfo.getter(BouncedRecipientInfo::bounceTypeAsString)).setter(BouncedRecipientInfo.setter(Builder::bounceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceType").build()}).build();
    private static final SdkField<RecipientDsnFields> RECIPIENT_DSN_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BouncedRecipientInfo.getter(BouncedRecipientInfo::recipientDsnFields)).setter(BouncedRecipientInfo.setter(Builder::recipientDsnFields)).constructor(RecipientDsnFields::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipientDsnFields").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPIENT_FIELD, RECIPIENT_ARN_FIELD, BOUNCE_TYPE_FIELD, RECIPIENT_DSN_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recipient;
    private final String recipientArn;
    private final String bounceType;
    private final RecipientDsnFields recipientDsnFields;

    private BouncedRecipientInfo(BuilderImpl builder) {
        this.recipient = builder.recipient;
        this.recipientArn = builder.recipientArn;
        this.bounceType = builder.bounceType;
        this.recipientDsnFields = builder.recipientDsnFields;
    }

    public String recipient() {
        return this.recipient;
    }

    public String recipientArn() {
        return this.recipientArn;
    }

    public BounceType bounceType() {
        return BounceType.fromValue(this.bounceType);
    }

    public String bounceTypeAsString() {
        return this.bounceType;
    }

    public RecipientDsnFields recipientDsnFields() {
        return this.recipientDsnFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recipient());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientDsnFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BouncedRecipientInfo)) {
            return false;
        }
        BouncedRecipientInfo other = (BouncedRecipientInfo)obj;
        return Objects.equals(this.recipient(), other.recipient()) && Objects.equals(this.recipientArn(), other.recipientArn()) && Objects.equals(this.bounceTypeAsString(), other.bounceTypeAsString()) && Objects.equals(this.recipientDsnFields(), other.recipientDsnFields());
    }

    public String toString() {
        return ToString.builder((String)"BouncedRecipientInfo").add("Recipient", (Object)this.recipient()).add("RecipientArn", (Object)this.recipientArn()).add("BounceType", (Object)this.bounceTypeAsString()).add("RecipientDsnFields", (Object)this.recipientDsnFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Recipient": {
                return Optional.ofNullable(clazz.cast(this.recipient()));
            }
            case "RecipientArn": {
                return Optional.ofNullable(clazz.cast(this.recipientArn()));
            }
            case "BounceType": {
                return Optional.ofNullable(clazz.cast(this.bounceTypeAsString()));
            }
            case "RecipientDsnFields": {
                return Optional.ofNullable(clazz.cast(this.recipientDsnFields()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BouncedRecipientInfo, T> g) {
        return obj -> g.apply((BouncedRecipientInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recipient;
        private String recipientArn;
        private String bounceType;
        private RecipientDsnFields recipientDsnFields;

        private BuilderImpl() {
        }

        private BuilderImpl(BouncedRecipientInfo model) {
            this.recipient(model.recipient);
            this.recipientArn(model.recipientArn);
            this.bounceType(model.bounceType);
            this.recipientDsnFields(model.recipientDsnFields);
        }

        public final String getRecipient() {
            return this.recipient;
        }

        @Override
        public final Builder recipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        public final void setRecipient(String recipient) {
            this.recipient = recipient;
        }

        public final String getRecipientArn() {
            return this.recipientArn;
        }

        @Override
        public final Builder recipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
            return this;
        }

        public final void setRecipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
        }

        public final String getBounceType() {
            return this.bounceType;
        }

        @Override
        public final Builder bounceType(String bounceType) {
            this.bounceType = bounceType;
            return this;
        }

        @Override
        public final Builder bounceType(BounceType bounceType) {
            this.bounceType(bounceType == null ? null : bounceType.toString());
            return this;
        }

        public final void setBounceType(String bounceType) {
            this.bounceType = bounceType;
        }

        public final RecipientDsnFields.Builder getRecipientDsnFields() {
            return this.recipientDsnFields != null ? this.recipientDsnFields.toBuilder() : null;
        }

        @Override
        public final Builder recipientDsnFields(RecipientDsnFields recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields;
            return this;
        }

        public final void setRecipientDsnFields(RecipientDsnFields.BuilderImpl recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields != null ? recipientDsnFields.build() : null;
        }

        public BouncedRecipientInfo build() {
            return new BouncedRecipientInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BouncedRecipientInfo> {
        public Builder recipient(String var1);

        public Builder recipientArn(String var1);

        public Builder bounceType(String var1);

        public Builder bounceType(BounceType var1);

        public Builder recipientDsnFields(RecipientDsnFields var1);

        default public Builder recipientDsnFields(Consumer<RecipientDsnFields.Builder> recipientDsnFields) {
            return this.recipientDsnFields((RecipientDsnFields)((RecipientDsnFields.Builder)RecipientDsnFields.builder().applyMutation(recipientDsnFields)).build());
        }
    }
}

