/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest;

public class SetReceiptRulePositionRequestMarshaller
implements Marshaller<Request<SetReceiptRulePositionRequest>, SetReceiptRulePositionRequest> {
    public Request<SetReceiptRulePositionRequest> marshall(SetReceiptRulePositionRequest setReceiptRulePositionRequest) {
        if (setReceiptRulePositionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)setReceiptRulePositionRequest, "SESClient");
        request.addParameter("Action", "SetReceiptRulePosition");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setReceiptRulePositionRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)setReceiptRulePositionRequest.ruleSetName()));
        }
        if (setReceiptRulePositionRequest.ruleName() != null) {
            request.addParameter("RuleName", StringUtils.fromString((String)setReceiptRulePositionRequest.ruleName()));
        }
        if (setReceiptRulePositionRequest.after() != null) {
            request.addParameter("After", StringUtils.fromString((String)setReceiptRulePositionRequest.after()));
        }
        return request;
    }
}

