/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.Iterator;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest;

public class SendTemplatedEmailRequestMarshaller
implements Marshaller<Request<SendTemplatedEmailRequest>, SendTemplatedEmailRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<SendTemplatedEmailRequest> marshall(SendTemplatedEmailRequest sendTemplatedEmailRequest) {
        List<MessageTag> tagsList;
        List<String> replyToAddressesList;
        Destination destination;
        if (sendTemplatedEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)sendTemplatedEmailRequest, "SESClient");
        request.addParameter("Action", "SendTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendTemplatedEmailRequest.source()));
        }
        if ((destination = sendTemplatedEmailRequest.destination()) != null) {
            Object bccAddressesList;
            List<String> ccAddressesList;
            List<String> toAddressesList = destination.toAddresses();
            if (toAddressesList != null) {
                if (!toAddressesList.isEmpty()) {
                    int toAddressesListIndex = 1;
                    for (String string : toAddressesList) {
                        if (string != null) {
                            request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString((String)string));
                        }
                        ++toAddressesListIndex;
                    }
                } else {
                    request.addParameter("Destination.ToAddresses", "");
                }
            }
            if ((ccAddressesList = destination.ccAddresses()) != null) {
                if (!ccAddressesList.isEmpty()) {
                    int ccAddressesListIndex = 1;
                    for (String string : ccAddressesList) {
                        if (string != null) {
                            request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString((String)string));
                        }
                        ++ccAddressesListIndex;
                    }
                } else {
                    request.addParameter("Destination.CcAddresses", "");
                }
            }
            if ((bccAddressesList = destination.bccAddresses()) != null) {
                if (!bccAddressesList.isEmpty()) {
                    boolean bl = true;
                    Iterator iterator = bccAddressesList.iterator();
                    while (iterator.hasNext()) {
                        void var7_16;
                        String bccAddressesListValue = (String)iterator.next();
                        if (bccAddressesListValue != null) {
                            request.addParameter("Destination.BccAddresses.member." + (int)var7_16, StringUtils.fromString((String)bccAddressesListValue));
                        }
                        ++var7_16;
                    }
                } else {
                    request.addParameter("Destination.BccAddresses", "");
                }
            }
        }
        if ((replyToAddressesList = sendTemplatedEmailRequest.replyToAddresses()) != null) {
            if (!replyToAddressesList.isEmpty()) {
                int replyToAddressesListIndex = 1;
                for (String string : replyToAddressesList) {
                    if (string != null) {
                        request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString((String)string));
                    }
                    ++replyToAddressesListIndex;
                }
            } else {
                request.addParameter("ReplyToAddresses", "");
            }
        }
        if (sendTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString((String)sendTemplatedEmailRequest.returnPath()));
        }
        if (sendTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendTemplatedEmailRequest.sourceArn()));
        }
        if (sendTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendTemplatedEmailRequest.returnPathArn()));
        }
        if ((tagsList = sendTemplatedEmailRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (MessageTag messageTag : tagsList) {
                    if (messageTag.name() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString((String)messageTag.name()));
                    }
                    if (messageTag.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)messageTag.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (sendTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendTemplatedEmailRequest.configurationSetName()));
        }
        if (sendTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringUtils.fromString((String)sendTemplatedEmailRequest.template()));
        }
        if (sendTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringUtils.fromString((String)sendTemplatedEmailRequest.templateArn()));
        }
        if (sendTemplatedEmailRequest.templateData() != null) {
            request.addParameter("TemplateData", StringUtils.fromString((String)sendTemplatedEmailRequest.templateData()));
        }
        return request;
    }
}

