/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatus;
import software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatusListCopier;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendBulkTemplatedEmailResponse
extends SESResponse
implements ToCopyableBuilder<Builder, SendBulkTemplatedEmailResponse> {
    private final List<BulkEmailDestinationStatus> status;

    private SendBulkTemplatedEmailResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    public List<BulkEmailDestinationStatus> status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkTemplatedEmailResponse)) {
            return false;
        }
        SendBulkTemplatedEmailResponse other = (SendBulkTemplatedEmailResponse)((Object)obj);
        return Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"SendBulkTemplatedEmailResponse").add("Status", this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private List<BulkEmailDestinationStatus> status;

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkTemplatedEmailResponse model) {
            this.status(model.status);
        }

        public final Collection<BulkEmailDestinationStatus.Builder> getStatus() {
            return this.status != null ? (Collection)this.status.stream().map(BulkEmailDestinationStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder status(Collection<BulkEmailDestinationStatus> status) {
            this.status = BulkEmailDestinationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(BulkEmailDestinationStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        public final void setStatus(Collection<BulkEmailDestinationStatus.BuilderImpl> status) {
            this.status = BulkEmailDestinationStatusListCopier.copyFromBuilder(status);
        }

        @Override
        public SendBulkTemplatedEmailResponse build() {
            return new SendBulkTemplatedEmailResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, SendBulkTemplatedEmailResponse> {
        public Builder status(Collection<BulkEmailDestinationStatus> var1);

        public Builder status(BulkEmailDestinationStatus ... var1);
    }
}

