/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.IdentityListCopier;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityMailFromDomainAttributesRequest
extends SESRequest
implements ToCopyableBuilder<Builder, GetIdentityMailFromDomainAttributesRequest> {
    private final List<String> identities;

    private GetIdentityMailFromDomainAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.identities = builder.identities;
    }

    public List<String> identities() {
        return this.identities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityMailFromDomainAttributesRequest)) {
            return false;
        }
        GetIdentityMailFromDomainAttributesRequest other = (GetIdentityMailFromDomainAttributesRequest)((Object)obj);
        return Objects.equals(this.identities(), other.identities());
    }

    public String toString() {
        return ToString.builder((String)"GetIdentityMailFromDomainAttributesRequest").add("Identities", this.identities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identities": {
                return Optional.of(clazz.cast(this.identities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private List<String> identities;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityMailFromDomainAttributesRequest model) {
            this.identities(model.identities);
        }

        public final Collection<String> getIdentities() {
            return this.identities;
        }

        @Override
        public final Builder identities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(String ... identities) {
            this.identities(Arrays.asList(identities));
            return this;
        }

        public final void setIdentities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityMailFromDomainAttributesRequest build() {
            return new GetIdentityMailFromDomainAttributesRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, GetIdentityMailFromDomainAttributesRequest> {
        public Builder identities(Collection<String> var1);

        public Builder identities(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

