/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.DimensionValueSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchDimensionConfiguration
implements ToCopyableBuilder<Builder, CloudWatchDimensionConfiguration> {
    private final String dimensionName;
    private final String dimensionValueSource;
    private final String defaultDimensionValue;

    private CloudWatchDimensionConfiguration(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueSource = builder.dimensionValueSource;
        this.defaultDimensionValue = builder.defaultDimensionValue;
    }

    public String dimensionName() {
        return this.dimensionName;
    }

    public DimensionValueSource dimensionValueSource() {
        return DimensionValueSource.fromValue(this.dimensionValueSource);
    }

    public String dimensionValueSourceString() {
        return this.dimensionValueSource;
    }

    public String defaultDimensionValue() {
        return this.defaultDimensionValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValueSourceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDimensionValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDimensionConfiguration)) {
            return false;
        }
        CloudWatchDimensionConfiguration other = (CloudWatchDimensionConfiguration)obj;
        return Objects.equals(this.dimensionName(), other.dimensionName()) && Objects.equals(this.dimensionValueSourceString(), other.dimensionValueSourceString()) && Objects.equals(this.defaultDimensionValue(), other.defaultDimensionValue());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchDimensionConfiguration").add("DimensionName", (Object)this.dimensionName()).add("DimensionValueSource", (Object)this.dimensionValueSourceString()).add("DefaultDimensionValue", (Object)this.defaultDimensionValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionName": {
                return Optional.of(clazz.cast(this.dimensionName()));
            }
            case "DimensionValueSource": {
                return Optional.of(clazz.cast(this.dimensionValueSourceString()));
            }
            case "DefaultDimensionValue": {
                return Optional.of(clazz.cast(this.defaultDimensionValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionName;
        private String dimensionValueSource;
        private String defaultDimensionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDimensionConfiguration model) {
            this.dimensionName(model.dimensionName);
            this.dimensionValueSource(model.dimensionValueSource);
            this.defaultDimensionValue(model.defaultDimensionValue);
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public final String getDimensionValueSource() {
            return this.dimensionValueSource;
        }

        @Override
        public final Builder dimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
            return this;
        }

        @Override
        public final Builder dimensionValueSource(DimensionValueSource dimensionValueSource) {
            this.dimensionValueSource(dimensionValueSource.toString());
            return this;
        }

        public final void setDimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
        }

        public final String getDefaultDimensionValue() {
            return this.defaultDimensionValue;
        }

        @Override
        public final Builder defaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
            return this;
        }

        public final void setDefaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
        }

        public CloudWatchDimensionConfiguration build() {
            return new CloudWatchDimensionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchDimensionConfiguration> {
        public Builder dimensionName(String var1);

        public Builder dimensionValueSource(String var1);

        public Builder dimensionValueSource(DimensionValueSource var1);

        public Builder defaultDimensionValue(String var1);
    }
}

