/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.TrackingOptions;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest;

public class UpdateConfigurationSetTrackingOptionsRequestMarshaller
implements Marshaller<Request<UpdateConfigurationSetTrackingOptionsRequest>, UpdateConfigurationSetTrackingOptionsRequest> {
    public Request<UpdateConfigurationSetTrackingOptionsRequest> marshall(UpdateConfigurationSetTrackingOptionsRequest updateConfigurationSetTrackingOptionsRequest) {
        TrackingOptions trackingOptions;
        if (updateConfigurationSetTrackingOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateConfigurationSetTrackingOptionsRequest, "SESClient");
        request.addParameter("Action", "UpdateConfigurationSetTrackingOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationSetTrackingOptionsRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)updateConfigurationSetTrackingOptionsRequest.configurationSetName()));
        }
        if ((trackingOptions = updateConfigurationSetTrackingOptionsRequest.trackingOptions()) != null && trackingOptions.customRedirectDomain() != null) {
            request.addParameter("TrackingOptions.CustomRedirectDomain", StringUtils.fromString((String)trackingOptions.customRedirectDomain()));
        }
        return request;
    }
}

