/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.TrackingOptions;

public class TrackingOptionsUnmarshaller
implements Unmarshaller<TrackingOptions, StaxUnmarshallerContext> {
    private static final TrackingOptionsUnmarshaller INSTANCE = new TrackingOptionsUnmarshaller();

    public TrackingOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TrackingOptions.Builder trackingOptions = TrackingOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("CustomRedirectDomain", targetDepth)) continue;
                trackingOptions.customRedirectDomain(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TrackingOptions)trackingOptions.build();
    }

    public static TrackingOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

