/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.TemplateMetadata;

public class TemplateMetadataUnmarshaller
implements Unmarshaller<TemplateMetadata, StaxUnmarshallerContext> {
    private static final TemplateMetadataUnmarshaller INSTANCE = new TemplateMetadataUnmarshaller();

    public TemplateMetadata unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TemplateMetadata.Builder templateMetadata = TemplateMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    templateMetadata.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CreatedTimestamp", targetDepth)) continue;
                templateMetadata.createdTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TemplateMetadata)templateMetadata.build();
    }

    public static TemplateMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

