/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest;

public class SetIdentityMailFromDomainRequestMarshaller
implements Marshaller<Request<SetIdentityMailFromDomainRequest>, SetIdentityMailFromDomainRequest> {
    public Request<SetIdentityMailFromDomainRequest> marshall(SetIdentityMailFromDomainRequest setIdentityMailFromDomainRequest) {
        if (setIdentityMailFromDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)setIdentityMailFromDomainRequest, "SESClient");
        request.addParameter("Action", "SetIdentityMailFromDomain");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIdentityMailFromDomainRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)setIdentityMailFromDomainRequest.identity()));
        }
        if (setIdentityMailFromDomainRequest.mailFromDomain() != null) {
            request.addParameter("MailFromDomain", StringUtils.fromString((String)setIdentityMailFromDomainRequest.mailFromDomain()));
        }
        if (setIdentityMailFromDomainRequest.behaviorOnMXFailureString() != null) {
            request.addParameter("BehaviorOnMXFailure", StringUtils.fromString((String)setIdentityMailFromDomainRequest.behaviorOnMXFailureString()));
        }
        return request;
    }
}

