/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.transform.AddHeaderActionUnmarshaller;
import software.amazon.awssdk.services.ses.transform.BounceActionUnmarshaller;
import software.amazon.awssdk.services.ses.transform.LambdaActionUnmarshaller;
import software.amazon.awssdk.services.ses.transform.S3ActionUnmarshaller;
import software.amazon.awssdk.services.ses.transform.SNSActionUnmarshaller;
import software.amazon.awssdk.services.ses.transform.StopActionUnmarshaller;
import software.amazon.awssdk.services.ses.transform.WorkmailActionUnmarshaller;

public class ReceiptActionUnmarshaller
implements Unmarshaller<ReceiptAction, StaxUnmarshallerContext> {
    private static final ReceiptActionUnmarshaller INSTANCE = new ReceiptActionUnmarshaller();

    public ReceiptAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReceiptAction.Builder receiptAction = ReceiptAction.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("S3Action", targetDepth)) {
                    receiptAction.s3Action(S3ActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BounceAction", targetDepth)) {
                    receiptAction.bounceAction(BounceActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("WorkmailAction", targetDepth)) {
                    receiptAction.workmailAction(WorkmailActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LambdaAction", targetDepth)) {
                    receiptAction.lambdaAction(LambdaActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StopAction", targetDepth)) {
                    receiptAction.stopAction(StopActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AddHeaderAction", targetDepth)) {
                    receiptAction.addHeaderAction(AddHeaderActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SNSAction", targetDepth)) continue;
                receiptAction.snsAction(SNSActionUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReceiptAction)receiptAction.build();
    }

    public static ReceiptActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

