/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.transform.ContentUnmarshaller;

public class BodyUnmarshaller
implements Unmarshaller<Body, StaxUnmarshallerContext> {
    private static final BodyUnmarshaller INSTANCE = new BodyUnmarshaller();

    public Body unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Body.Builder body = Body.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Text", targetDepth)) {
                    body.text(ContentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Html", targetDepth)) continue;
                body.html(ContentUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Body)body.build();
    }

    public static BodyUnmarshaller getInstance() {
        return INSTANCE;
    }
}

