/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ses.model.AddHeaderAction;
import software.amazon.awssdk.services.ses.model.BounceAction;
import software.amazon.awssdk.services.ses.model.LambdaAction;
import software.amazon.awssdk.services.ses.model.S3Action;
import software.amazon.awssdk.services.ses.model.SNSAction;
import software.amazon.awssdk.services.ses.model.StopAction;
import software.amazon.awssdk.services.ses.model.WorkmailAction;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiptAction
implements ToCopyableBuilder<Builder, ReceiptAction> {
    private final S3Action s3Action;
    private final BounceAction bounceAction;
    private final WorkmailAction workmailAction;
    private final LambdaAction lambdaAction;
    private final StopAction stopAction;
    private final AddHeaderAction addHeaderAction;
    private final SNSAction snsAction;

    private ReceiptAction(BuilderImpl builder) {
        this.s3Action = builder.s3Action;
        this.bounceAction = builder.bounceAction;
        this.workmailAction = builder.workmailAction;
        this.lambdaAction = builder.lambdaAction;
        this.stopAction = builder.stopAction;
        this.addHeaderAction = builder.addHeaderAction;
        this.snsAction = builder.snsAction;
    }

    public S3Action s3Action() {
        return this.s3Action;
    }

    public BounceAction bounceAction() {
        return this.bounceAction;
    }

    public WorkmailAction workmailAction() {
        return this.workmailAction;
    }

    public LambdaAction lambdaAction() {
        return this.lambdaAction;
    }

    public StopAction stopAction() {
        return this.stopAction;
    }

    public AddHeaderAction addHeaderAction() {
        return this.addHeaderAction;
    }

    public SNSAction snsAction() {
        return this.snsAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Action());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.workmailAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.addHeaderAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptAction)) {
            return false;
        }
        ReceiptAction other = (ReceiptAction)obj;
        return Objects.equals(this.s3Action(), other.s3Action()) && Objects.equals(this.bounceAction(), other.bounceAction()) && Objects.equals(this.workmailAction(), other.workmailAction()) && Objects.equals(this.lambdaAction(), other.lambdaAction()) && Objects.equals(this.stopAction(), other.stopAction()) && Objects.equals(this.addHeaderAction(), other.addHeaderAction()) && Objects.equals(this.snsAction(), other.snsAction());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.s3Action() != null) {
            sb.append("S3Action: ").append(this.s3Action()).append(",");
        }
        if (this.bounceAction() != null) {
            sb.append("BounceAction: ").append(this.bounceAction()).append(",");
        }
        if (this.workmailAction() != null) {
            sb.append("WorkmailAction: ").append(this.workmailAction()).append(",");
        }
        if (this.lambdaAction() != null) {
            sb.append("LambdaAction: ").append(this.lambdaAction()).append(",");
        }
        if (this.stopAction() != null) {
            sb.append("StopAction: ").append(this.stopAction()).append(",");
        }
        if (this.addHeaderAction() != null) {
            sb.append("AddHeaderAction: ").append(this.addHeaderAction()).append(",");
        }
        if (this.snsAction() != null) {
            sb.append("SNSAction: ").append(this.snsAction()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Action": {
                return Optional.of(clazz.cast(this.s3Action()));
            }
            case "BounceAction": {
                return Optional.of(clazz.cast(this.bounceAction()));
            }
            case "WorkmailAction": {
                return Optional.of(clazz.cast(this.workmailAction()));
            }
            case "LambdaAction": {
                return Optional.of(clazz.cast(this.lambdaAction()));
            }
            case "StopAction": {
                return Optional.of(clazz.cast(this.stopAction()));
            }
            case "AddHeaderAction": {
                return Optional.of(clazz.cast(this.addHeaderAction()));
            }
            case "SNSAction": {
                return Optional.of(clazz.cast(this.snsAction()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private S3Action s3Action;
        private BounceAction bounceAction;
        private WorkmailAction workmailAction;
        private LambdaAction lambdaAction;
        private StopAction stopAction;
        private AddHeaderAction addHeaderAction;
        private SNSAction snsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptAction model) {
            this.s3Action(model.s3Action);
            this.bounceAction(model.bounceAction);
            this.workmailAction(model.workmailAction);
            this.lambdaAction(model.lambdaAction);
            this.stopAction(model.stopAction);
            this.addHeaderAction(model.addHeaderAction);
            this.snsAction(model.snsAction);
        }

        public final S3Action.Builder getS3Action() {
            return this.s3Action != null ? this.s3Action.toBuilder() : null;
        }

        @Override
        public final Builder s3Action(S3Action s3Action) {
            this.s3Action = s3Action;
            return this;
        }

        public final void setS3Action(S3Action.BuilderImpl s3Action) {
            this.s3Action = s3Action != null ? s3Action.build() : null;
        }

        public final BounceAction.Builder getBounceAction() {
            return this.bounceAction != null ? this.bounceAction.toBuilder() : null;
        }

        @Override
        public final Builder bounceAction(BounceAction bounceAction) {
            this.bounceAction = bounceAction;
            return this;
        }

        public final void setBounceAction(BounceAction.BuilderImpl bounceAction) {
            this.bounceAction = bounceAction != null ? bounceAction.build() : null;
        }

        public final WorkmailAction.Builder getWorkmailAction() {
            return this.workmailAction != null ? this.workmailAction.toBuilder() : null;
        }

        @Override
        public final Builder workmailAction(WorkmailAction workmailAction) {
            this.workmailAction = workmailAction;
            return this;
        }

        public final void setWorkmailAction(WorkmailAction.BuilderImpl workmailAction) {
            this.workmailAction = workmailAction != null ? workmailAction.build() : null;
        }

        public final LambdaAction.Builder getLambdaAction() {
            return this.lambdaAction != null ? this.lambdaAction.toBuilder() : null;
        }

        @Override
        public final Builder lambdaAction(LambdaAction lambdaAction) {
            this.lambdaAction = lambdaAction;
            return this;
        }

        public final void setLambdaAction(LambdaAction.BuilderImpl lambdaAction) {
            this.lambdaAction = lambdaAction != null ? lambdaAction.build() : null;
        }

        public final StopAction.Builder getStopAction() {
            return this.stopAction != null ? this.stopAction.toBuilder() : null;
        }

        @Override
        public final Builder stopAction(StopAction stopAction) {
            this.stopAction = stopAction;
            return this;
        }

        public final void setStopAction(StopAction.BuilderImpl stopAction) {
            this.stopAction = stopAction != null ? stopAction.build() : null;
        }

        public final AddHeaderAction.Builder getAddHeaderAction() {
            return this.addHeaderAction != null ? this.addHeaderAction.toBuilder() : null;
        }

        @Override
        public final Builder addHeaderAction(AddHeaderAction addHeaderAction) {
            this.addHeaderAction = addHeaderAction;
            return this;
        }

        public final void setAddHeaderAction(AddHeaderAction.BuilderImpl addHeaderAction) {
            this.addHeaderAction = addHeaderAction != null ? addHeaderAction.build() : null;
        }

        public final SNSAction.Builder getSNSAction() {
            return this.snsAction != null ? this.snsAction.toBuilder() : null;
        }

        @Override
        public final Builder snsAction(SNSAction snsAction) {
            this.snsAction = snsAction;
            return this;
        }

        public final void setSNSAction(SNSAction.BuilderImpl snsAction) {
            this.snsAction = snsAction != null ? snsAction.build() : null;
        }

        public ReceiptAction build() {
            return new ReceiptAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiptAction> {
        public Builder s3Action(S3Action var1);

        default public Builder s3Action(Consumer<S3Action.Builder> s3Action) {
            return this.s3Action((S3Action)((S3Action.Builder)S3Action.builder().apply(s3Action)).build());
        }

        public Builder bounceAction(BounceAction var1);

        default public Builder bounceAction(Consumer<BounceAction.Builder> bounceAction) {
            return this.bounceAction((BounceAction)((BounceAction.Builder)BounceAction.builder().apply(bounceAction)).build());
        }

        public Builder workmailAction(WorkmailAction var1);

        default public Builder workmailAction(Consumer<WorkmailAction.Builder> workmailAction) {
            return this.workmailAction((WorkmailAction)((WorkmailAction.Builder)WorkmailAction.builder().apply(workmailAction)).build());
        }

        public Builder lambdaAction(LambdaAction var1);

        default public Builder lambdaAction(Consumer<LambdaAction.Builder> lambdaAction) {
            return this.lambdaAction((LambdaAction)((LambdaAction.Builder)LambdaAction.builder().apply(lambdaAction)).build());
        }

        public Builder stopAction(StopAction var1);

        default public Builder stopAction(Consumer<StopAction.Builder> stopAction) {
            return this.stopAction((StopAction)((StopAction.Builder)StopAction.builder().apply(stopAction)).build());
        }

        public Builder addHeaderAction(AddHeaderAction var1);

        default public Builder addHeaderAction(Consumer<AddHeaderAction.Builder> addHeaderAction) {
            return this.addHeaderAction((AddHeaderAction)((AddHeaderAction.Builder)AddHeaderAction.builder().apply(addHeaderAction)).build());
        }

        public Builder snsAction(SNSAction var1);

        default public Builder snsAction(Consumer<SNSAction.Builder> snsAction) {
            return this.snsAction((SNSAction)((SNSAction.Builder)SNSAction.builder().apply(snsAction)).build());
        }
    }
}

