/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTemplatesRequest
extends SESRequest
implements ToCopyableBuilder<Builder, ListTemplatesRequest> {
    private final String nextToken;
    private final Integer maxItems;

    private ListTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesRequest)) {
            return false;
        }
        ListTemplatesRequest other = (ListTemplatesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesRequest model) {
            this.nextToken(model.nextToken);
            this.maxItems(model.maxItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTemplatesRequest build() {
            return new ListTemplatesRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, ListTemplatesRequest> {
        public Builder nextToken(String var1);

        public Builder maxItems(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

