/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.ConfigurationSet;
import software.amazon.awssdk.services.ses.model.ConfigurationSetsCopier;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListConfigurationSetsResponse
extends SESResponse
implements ToCopyableBuilder<Builder, ListConfigurationSetsResponse> {
    private final List<ConfigurationSet> configurationSets;
    private final String nextToken;

    private ListConfigurationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    public List<ConfigurationSet> configurationSets() {
        return this.configurationSets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationSetsResponse)) {
            return false;
        }
        ListConfigurationSetsResponse other = (ListConfigurationSetsResponse)((Object)obj);
        return Objects.equals(this.configurationSets(), other.configurationSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configurationSets() != null) {
            sb.append("ConfigurationSets: ").append(this.configurationSets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSets": {
                return Optional.of(clazz.cast(this.configurationSets()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationSet> configurationSets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationSetsResponse model) {
            this.configurationSets(model.configurationSets);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConfigurationSet.Builder> getConfigurationSets() {
            return this.configurationSets != null ? (Collection)this.configurationSets.stream().map(ConfigurationSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationSets(Collection<ConfigurationSet> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(ConfigurationSet ... configurationSets) {
            this.configurationSets(Arrays.asList(configurationSets));
            return this;
        }

        public final void setConfigurationSets(Collection<ConfigurationSet.BuilderImpl> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copyFromBuilder(configurationSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigurationSetsResponse build() {
            return new ListConfigurationSetsResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, ListConfigurationSetsResponse> {
        public Builder configurationSets(Collection<ConfigurationSet> var1);

        public Builder configurationSets(ConfigurationSet ... var1);

        public Builder nextToken(String var1);
    }
}

