/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSendQuotaResponse
extends SESResponse
implements ToCopyableBuilder<Builder, GetSendQuotaResponse> {
    private final Double max24HourSend;
    private final Double maxSendRate;
    private final Double sentLast24Hours;

    private GetSendQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.max24HourSend = builder.max24HourSend;
        this.maxSendRate = builder.maxSendRate;
        this.sentLast24Hours = builder.sentLast24Hours;
    }

    public Double max24HourSend() {
        return this.max24HourSend;
    }

    public Double maxSendRate() {
        return this.maxSendRate;
    }

    public Double sentLast24Hours() {
        return this.sentLast24Hours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.max24HourSend());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSendRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentLast24Hours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendQuotaResponse)) {
            return false;
        }
        GetSendQuotaResponse other = (GetSendQuotaResponse)((Object)obj);
        return Objects.equals(this.max24HourSend(), other.max24HourSend()) && Objects.equals(this.maxSendRate(), other.maxSendRate()) && Objects.equals(this.sentLast24Hours(), other.sentLast24Hours());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.max24HourSend() != null) {
            sb.append("Max24HourSend: ").append(this.max24HourSend()).append(",");
        }
        if (this.maxSendRate() != null) {
            sb.append("MaxSendRate: ").append(this.maxSendRate()).append(",");
        }
        if (this.sentLast24Hours() != null) {
            sb.append("SentLast24Hours: ").append(this.sentLast24Hours()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Max24HourSend": {
                return Optional.of(clazz.cast(this.max24HourSend()));
            }
            case "MaxSendRate": {
                return Optional.of(clazz.cast(this.maxSendRate()));
            }
            case "SentLast24Hours": {
                return Optional.of(clazz.cast(this.sentLast24Hours()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private Double max24HourSend;
        private Double maxSendRate;
        private Double sentLast24Hours;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendQuotaResponse model) {
            this.max24HourSend(model.max24HourSend);
            this.maxSendRate(model.maxSendRate);
            this.sentLast24Hours(model.sentLast24Hours);
        }

        public final Double getMax24HourSend() {
            return this.max24HourSend;
        }

        @Override
        public final Builder max24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
            return this;
        }

        public final void setMax24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
        }

        public final Double getMaxSendRate() {
            return this.maxSendRate;
        }

        @Override
        public final Builder maxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
            return this;
        }

        public final void setMaxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
        }

        public final Double getSentLast24Hours() {
            return this.sentLast24Hours;
        }

        @Override
        public final Builder sentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
            return this;
        }

        public final void setSentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
        }

        @Override
        public GetSendQuotaResponse build() {
            return new GetSendQuotaResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, GetSendQuotaResponse> {
        public Builder max24HourSend(Double var1);

        public Builder maxSendRate(Double var1);

        public Builder sentLast24Hours(Double var1);
    }
}

