/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BulkEmailDestination
implements ToCopyableBuilder<Builder, BulkEmailDestination> {
    private final Destination destination;
    private final List<MessageTag> replacementTags;
    private final String replacementTemplateData;

    private BulkEmailDestination(BuilderImpl builder) {
        this.destination = builder.destination;
        this.replacementTags = builder.replacementTags;
        this.replacementTemplateData = builder.replacementTemplateData;
    }

    public Destination destination() {
        return this.destination;
    }

    public List<MessageTag> replacementTags() {
        return this.replacementTags;
    }

    public String replacementTemplateData() {
        return this.replacementTemplateData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementTemplateData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailDestination)) {
            return false;
        }
        BulkEmailDestination other = (BulkEmailDestination)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.replacementTags(), other.replacementTags()) && Objects.equals(this.replacementTemplateData(), other.replacementTemplateData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        if (this.replacementTags() != null) {
            sb.append("ReplacementTags: ").append(this.replacementTags()).append(",");
        }
        if (this.replacementTemplateData() != null) {
            sb.append("ReplacementTemplateData: ").append(this.replacementTemplateData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "ReplacementTags": {
                return Optional.of(clazz.cast(this.replacementTags()));
            }
            case "ReplacementTemplateData": {
                return Optional.of(clazz.cast(this.replacementTemplateData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Destination destination;
        private List<MessageTag> replacementTags;
        private String replacementTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailDestination model) {
            this.destination(model.destination);
            this.replacementTags(model.replacementTags);
            this.replacementTemplateData(model.replacementTemplateData);
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<MessageTag.Builder> getReplacementTags() {
            return this.replacementTags != null ? (Collection)this.replacementTags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replacementTags(Collection<MessageTag> replacementTags) {
            this.replacementTags = MessageTagListCopier.copy(replacementTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(MessageTag ... replacementTags) {
            this.replacementTags(Arrays.asList(replacementTags));
            return this;
        }

        public final void setReplacementTags(Collection<MessageTag.BuilderImpl> replacementTags) {
            this.replacementTags = MessageTagListCopier.copyFromBuilder(replacementTags);
        }

        public final String getReplacementTemplateData() {
            return this.replacementTemplateData;
        }

        @Override
        public final Builder replacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
            return this;
        }

        public final void setReplacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
        }

        public BulkEmailDestination build() {
            return new BulkEmailDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BulkEmailDestination> {
        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().apply(destination)).build());
        }

        public Builder replacementTags(Collection<MessageTag> var1);

        public Builder replacementTags(MessageTag ... var1);

        public Builder replacementTemplateData(String var1);
    }
}

