/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest;

public class VerifyEmailIdentityRequestMarshaller
implements Marshaller<Request<VerifyEmailIdentityRequest>, VerifyEmailIdentityRequest> {
    public Request<VerifyEmailIdentityRequest> marshall(VerifyEmailIdentityRequest verifyEmailIdentityRequest) {
        if (verifyEmailIdentityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)verifyEmailIdentityRequest, "SESClient");
        request.addParameter("Action", "VerifyEmailIdentity");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (verifyEmailIdentityRequest.emailAddress() != null) {
            request.addParameter("EmailAddress", StringUtils.fromString((String)verifyEmailIdentityRequest.emailAddress()));
        }
        return request;
    }
}

