/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiptIpFilter
implements ToCopyableBuilder<Builder, ReceiptIpFilter> {
    private final String policy;
    private final String cidr;

    private ReceiptIpFilter(BuilderImpl builder) {
        this.policy = builder.policy;
        this.cidr = builder.cidr;
    }

    public ReceiptFilterPolicy policy() {
        return ReceiptFilterPolicy.fromValue(this.policy);
    }

    public String policyString() {
        return this.policy;
    }

    public String cidr() {
        return this.cidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyString() == null ? 0 : this.policyString().hashCode());
        hashCode = 31 * hashCode + (this.cidr() == null ? 0 : this.cidr().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptIpFilter)) {
            return false;
        }
        ReceiptIpFilter other = (ReceiptIpFilter)obj;
        if (other.policyString() == null ^ this.policyString() == null) {
            return false;
        }
        if (other.policyString() != null && !other.policyString().equals(this.policyString())) {
            return false;
        }
        if (other.cidr() == null ^ this.cidr() == null) {
            return false;
        }
        return other.cidr() == null || other.cidr().equals(this.cidr());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyString() != null) {
            sb.append("Policy: ").append(this.policyString()).append(",");
        }
        if (this.cidr() != null) {
            sb.append("Cidr: ").append(this.cidr()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.of(clazz.cast(this.policyString()));
            }
            case "Cidr": {
                return Optional.of(clazz.cast(this.cidr()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policy;
        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptIpFilter model) {
            this.policy(model.policy);
            this.cidr(model.cidr);
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public final Builder policy(ReceiptFilterPolicy policy) {
            this.policy(policy.toString());
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getCidr() {
            return this.cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public ReceiptIpFilter build() {
            return new ReceiptIpFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiptIpFilter> {
        public Builder policy(String var1);

        public Builder policy(ReceiptFilterPolicy var1);

        public Builder cidr(String var1);
    }
}

