/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ses.model.CloudWatchDestination;
import software.amazon.awssdk.services.ses.model.EventType;
import software.amazon.awssdk.services.ses.model.EventTypesCopier;
import software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventDestination
implements ToCopyableBuilder<Builder, EventDestination> {
    private final String name;
    private final Boolean enabled;
    private final List<String> matchingEventTypes;
    private final KinesisFirehoseDestination kinesisFirehoseDestination;
    private final CloudWatchDestination cloudWatchDestination;

    private EventDestination(BuilderImpl builder) {
        this.name = builder.name;
        this.enabled = builder.enabled;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.cloudWatchDestination = builder.cloudWatchDestination;
    }

    public String name() {
        return this.name;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<EventType> matchingEventTypes() {
        return TypeConverter.convert(this.matchingEventTypes, EventType::fromValue);
    }

    public List<String> matchingEventTypesStrings() {
        return this.matchingEventTypes;
    }

    public KinesisFirehoseDestination kinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public CloudWatchDestination cloudWatchDestination() {
        return this.cloudWatchDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.matchingEventTypesStrings() == null ? 0 : this.matchingEventTypesStrings().hashCode());
        hashCode = 31 * hashCode + (this.kinesisFirehoseDestination() == null ? 0 : this.kinesisFirehoseDestination().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchDestination() == null ? 0 : this.cloudWatchDestination().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestination)) {
            return false;
        }
        EventDestination other = (EventDestination)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.matchingEventTypesStrings() == null ^ this.matchingEventTypesStrings() == null) {
            return false;
        }
        if (other.matchingEventTypesStrings() != null && !other.matchingEventTypesStrings().equals(this.matchingEventTypesStrings())) {
            return false;
        }
        if (other.kinesisFirehoseDestination() == null ^ this.kinesisFirehoseDestination() == null) {
            return false;
        }
        if (other.kinesisFirehoseDestination() != null && !other.kinesisFirehoseDestination().equals(this.kinesisFirehoseDestination())) {
            return false;
        }
        if (other.cloudWatchDestination() == null ^ this.cloudWatchDestination() == null) {
            return false;
        }
        return other.cloudWatchDestination() == null || other.cloudWatchDestination().equals(this.cloudWatchDestination());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.matchingEventTypesStrings() != null) {
            sb.append("MatchingEventTypes: ").append(this.matchingEventTypesStrings()).append(",");
        }
        if (this.kinesisFirehoseDestination() != null) {
            sb.append("KinesisFirehoseDestination: ").append(this.kinesisFirehoseDestination()).append(",");
        }
        if (this.cloudWatchDestination() != null) {
            sb.append("CloudWatchDestination: ").append(this.cloudWatchDestination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "MatchingEventTypes": {
                return Optional.of(clazz.cast(this.matchingEventTypesStrings()));
            }
            case "KinesisFirehoseDestination": {
                return Optional.of(clazz.cast(this.kinesisFirehoseDestination()));
            }
            case "CloudWatchDestination": {
                return Optional.of(clazz.cast(this.cloudWatchDestination()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean enabled;
        private List<String> matchingEventTypes;
        private KinesisFirehoseDestination kinesisFirehoseDestination;
        private CloudWatchDestination cloudWatchDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDestination model) {
            this.name(model.name);
            this.enabled(model.enabled);
            this.matchingEventTypes(model.matchingEventTypes);
            this.kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            this.cloudWatchDestination(model.cloudWatchDestination);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<String> getMatchingEventTypes() {
            return this.matchingEventTypes;
        }

        @Override
        public final Builder matchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(String ... matchingEventTypes) {
            this.matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final void setMatchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        public final CloudWatchDestination.Builder getCloudWatchDestination() {
            return this.cloudWatchDestination != null ? this.cloudWatchDestination.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination;
            return this;
        }

        public final void setCloudWatchDestination(CloudWatchDestination.BuilderImpl cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination != null ? cloudWatchDestination.build() : null;
        }

        public EventDestination build() {
            return new EventDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventDestination> {
        public Builder name(String var1);

        public Builder enabled(Boolean var1);

        public Builder matchingEventTypes(Collection<String> var1);

        public Builder matchingEventTypes(String ... var1);

        public Builder kinesisFirehoseDestination(KinesisFirehoseDestination var1);

        public Builder cloudWatchDestination(CloudWatchDestination var1);
    }
}

