/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata;
import software.amazon.awssdk.services.ses.model.ReceiptRulesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReceiptRuleSetResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
    private final ReceiptRuleSetMetadata metadata;
    private final List<ReceiptRule> rules;

    private DescribeReceiptRuleSetResponse(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.rules = builder.rules;
    }

    public ReceiptRuleSetMetadata metadata() {
        return this.metadata;
    }

    public List<ReceiptRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleSetResponse)) {
            return false;
        }
        DescribeReceiptRuleSetResponse other = (DescribeReceiptRuleSetResponse)((Object)obj);
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ReceiptRuleSetMetadata metadata;
        private List<ReceiptRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleSetResponse model) {
            this.metadata(model.metadata);
            this.rules(model.rules);
        }

        public final ReceiptRuleSetMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ReceiptRuleSetMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Collection<ReceiptRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(ReceiptRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReceiptRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ReceiptRule.BuilderImpl> rules) {
            this.rules = ReceiptRulesListCopier.copyFromBuilder(rules);
        }

        public DescribeReceiptRuleSetResponse build() {
            return new DescribeReceiptRuleSetResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
        public Builder metadata(ReceiptRuleSetMetadata var1);

        public Builder rules(Collection<ReceiptRule> var1);

        public Builder rules(ReceiptRule ... var1);
    }
}

