/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationSetRequest> {
    private final String configurationSetName;
    private final List<String> configurationSetAttributeNames;

    private DescribeConfigurationSetRequest(BuilderImpl builder) {
        this.configurationSetName = builder.configurationSetName;
        this.configurationSetAttributeNames = builder.configurationSetAttributeNames;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public List<ConfigurationSetAttribute> configurationSetAttributeNames() {
        return TypeConverter.convert(this.configurationSetAttributeNames, ConfigurationSetAttribute::fromValue);
    }

    public List<String> configurationSetAttributeNamesStrings() {
        return this.configurationSetAttributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configurationSetName() == null ? 0 : this.configurationSetName().hashCode());
        hashCode = 31 * hashCode + (this.configurationSetAttributeNamesStrings() == null ? 0 : this.configurationSetAttributeNamesStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetRequest)) {
            return false;
        }
        DescribeConfigurationSetRequest other = (DescribeConfigurationSetRequest)((Object)obj);
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        if (other.configurationSetName() != null && !other.configurationSetName().equals(this.configurationSetName())) {
            return false;
        }
        if (other.configurationSetAttributeNamesStrings() == null ^ this.configurationSetAttributeNamesStrings() == null) {
            return false;
        }
        return other.configurationSetAttributeNamesStrings() == null || other.configurationSetAttributeNamesStrings().equals(this.configurationSetAttributeNamesStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.configurationSetName()).append(",");
        }
        if (this.configurationSetAttributeNamesStrings() != null) {
            sb.append("ConfigurationSetAttributeNames: ").append(this.configurationSetAttributeNamesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.of(clazz.cast(this.configurationSetName()));
            }
            case "ConfigurationSetAttributeNames": {
                return Optional.of(clazz.cast(this.configurationSetAttributeNamesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationSetName;
        private List<String> configurationSetAttributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetRequest model) {
            this.configurationSetName(model.configurationSetName);
            this.configurationSetAttributeNames(model.configurationSetAttributeNames);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Collection<String> getConfigurationSetAttributeNames() {
            return this.configurationSetAttributeNames;
        }

        @Override
        public final Builder configurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNames(String ... configurationSetAttributeNames) {
            this.configurationSetAttributeNames(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        public final void setConfigurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
        }

        public DescribeConfigurationSetRequest build() {
            return new DescribeConfigurationSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConfigurationSetRequest> {
        public Builder configurationSetName(String var1);

        public Builder configurationSetAttributeNames(Collection<String> var1);

        public Builder configurationSetAttributeNames(String ... var1);
    }
}

